/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.profiler;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.schedule.XSchedule;
import org.xyou.xcommon.tool.XStr;

public final class Model {
    private final String nameService = XStr.toSnakeFromKebab(XApp.getName());
    private final Map<String, Counter> mapCounter = new HashMap<String, Counter>();
    private final Map<String, Gauge> mapGauge = new HashMap<String, Gauge>();
    private final Map<String, Summary> mapSummary = new HashMap<String, Summary>();
    private final XSchedule scheduleGauge = new XSchedule();
    private final transient Map<String, Integer> mapNumObject = new HashMap<String, Integer>();

    private Model() {
    }

    public static Model getInst() {
        return Holder.INST;
    }

    private String buildNameMetric(String nameProfiler) {
        return this.nameService + ":" + nameProfiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getMetric(String name, Map<String, V> mapMetric, Function<String, V> buildMetric) {
        String nameMetric = this.buildNameMetric(name);
        if (!mapMetric.containsKey(nameMetric)) {
            Map<String, V> map = mapMetric;
            synchronized (map) {
                if (!mapMetric.containsKey(nameMetric)) {
                    V metric = buildMetric.apply(nameMetric);
                    mapMetric.put(nameMetric, metric);
                }
            }
        }
        return mapMetric.get(nameMetric);
    }

    Counter getCounter(String name) {
        return this.getMetric(name, this.mapCounter, k -> (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name(k)).help("x")).register());
    }

    Gauge getGauge(String name) {
        return this.getMetric(name, this.mapGauge, k -> (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(k)).help("x")).register());
    }

    Summary getSummary(String name) {
        return this.getMetric(name, this.mapSummary, k -> (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name(k)).help("x")).register());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XProfilerObj createObj(Object obj) {
        Map<String, Integer> map = this.mapNumObject;
        synchronized (map) {
            String nameCls = obj.getClass().getSimpleName();
            String name = XObj.fromObject(obj).getStr("name");
            Integer numObject = this.mapNumObject.getOrDefault(name, 0);
            String idObject = numObject.toString();
            String nameClsSnakeCase = XStr.toSnakeFromPascal(nameCls);
            String nameRegister = String.join((CharSequence)":", nameClsSnakeCase, name, idObject);
            numObject = numObject + 1;
            this.mapNumObject.put(name, numObject);
            return new XProfilerObj(nameRegister);
        }
    }

    String getNameService() {
        return this.nameService;
    }

    Map<String, Counter> getMapCounter() {
        return this.mapCounter;
    }

    Map<String, Gauge> getMapGauge() {
        return this.mapGauge;
    }

    Map<String, Summary> getMapSummary() {
        return this.mapSummary;
    }

    XSchedule getScheduleGauge() {
        return this.scheduleGauge;
    }

    Map<String, Integer> getMapNumObject() {
        return this.mapNumObject;
    }

    private static class Holder {
        public static final Model INST = new Model();

        private Holder() {
        }
    }
}

