/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.profiler;

import io.prometheus.client.Summary;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.profiler.Model;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.profiler.XProfilerTimer;
import org.xyou.xcommon.schedule.XScheduleParam;
import org.xyou.xcommon.tool.XCvt;

public final class XProfiler {
    private static final XLogger LOGGER = new XLogger();

    public static XProfilerObj createObj(Object obj) {
        return Model.getInst().createObj(obj);
    }

    public static double getCounter(String name) {
        return Model.getInst().getCounter(name).get();
    }

    public static void incCounter(String name) {
        XProfiler.incCounter(name, 1.0);
    }

    public static void incCounter(String name, double value) {
        Model.getInst().getCounter(name).inc(value);
    }

    public static double getGauge(String name) {
        return Model.getInst().getGauge(name).get();
    }

    public static void setGauge(String name, double value) {
        Model.getInst().getGauge(name).set(value);
    }

    public static void incGauge(String name) {
        XProfiler.incGauge(name, 1.0);
    }

    public static void incGauge(String name, double value) {
        Model.getInst().getGauge(name).inc();
    }

    public static void decGauge(String name) {
        XProfiler.decGauge(name, 1.0);
    }

    public static void decGauge(String name, double value) {
        Model.getInst().getGauge(name).dec();
    }

    public static XProfilerTimer getTimer(String name) {
        Summary metric = Model.getInst().getSummary(name);
        Summary.Timer timer = metric.startTimer();
        return new XProfilerTimer(timer);
    }

    public static ScheduledFuture<?> scheduleGauge(String name, Supplier<Number> func) {
        return Model.getInst().getScheduleGauge().scheduleAtFixedRate(XScheduleParam.builder().func(() -> {
            double value = ((Number)func.get()).doubleValue();
            XProfiler.setGauge(name, value);
        }).msPeriod(1000L).build());
    }

    static {
        try {
            XConfig config = new XConfig("main");
            DefaultExports.initialize();
            String host = config.getStr("host");
            String[] arrPartHost = host.split(":");
            String ip = arrPartHost[0];
            Integer port = XCvt.toInt(arrPartHost[1]);
            LOGGER.info("Profiler starting at " + host);
            new HTTPServer(ip, port.intValue());
            LOGGER.info("Profiler started successfully at " + host);
        }
        catch (Throwable ex) {
            LOGGER.error(ex);
        }
    }
}

