/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;

public final class XQueue<V>
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer sizeMax;
    private Boolean isProfiler;
    private transient BlockingQueue<V> queue;
    private transient XProfilerObj objProfiler;

    public XQueue(int sizeMax) {
        this.name = null;
        this.sizeMax = sizeMax;
        this.isProfiler = false;
        this.queue = this.initQueue(sizeMax);
        this.objProfiler = null;
    }

    public XQueue(String name) {
        this.name = name;
        XConfig config = new XConfig(name);
        this.name = name;
        this.sizeMax = config.getInt("sizeMax");
        this.isProfiler = config.getBool("isProfiler", false);
        this.queue = this.initQueue(this.sizeMax);
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(this);
            this.objProfiler.scheduleGauge("size", this::size);
        }
    }

    private BlockingQueue<V> initQueue(int sizeMax) {
        return new ArrayBlockingQueue(sizeMax);
    }

    public boolean isFull() {
        return this.queue.size() == this.sizeMax.intValue();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public List<V> take(int numData) {
        ArrayList<V> lsData = new ArrayList<V>();
        try {
            for (int idxData = 0; idxData < numData; ++idxData) {
                V data = this.queue.take();
                lsData.add(data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lsData;
    }

    public V take() {
        try {
            return this.queue.take();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public V poll() {
        return (V)this.queue.poll();
    }

    public void put(V data) {
        try {
            this.queue.put(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean offer(V data) {
        return this.queue.offer(data);
    }

    public boolean remove(V data) {
        return this.queue.remove(data);
    }

    public String getName() {
        return this.name;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }
}

