/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.tool.XCls;

public final class XReflect {
    public static boolean set(Object obj, Object key, Object value) {
        try {
            if (key instanceof String) {
                Field field = obj.getClass().getDeclaredField((String)key);
                return XReflect.set(obj, field, value);
            }
            if (key instanceof Field) {
                Field field = (Field)key;
                field.setAccessible(true);
                field.set(obj, value);
                return true;
            }
            XEx.createClassInvalid(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static <V> V get(Object obj, Object key) {
        try {
            if (key instanceof String) {
                return XReflect.get(obj, obj.getClass().getDeclaredField((String)key));
            }
            if (key instanceof Field) {
                Field field = (Field)key;
                field.setAccessible(true);
                Object value = field.get(obj);
                return (V)value;
            }
            XEx.createClassInvalid(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static List<Field> getLsField(Object obj) {
        Field[] arrField;
        Class<?> cls = XCls.getClass(obj);
        ArrayList<Field> lsField = new ArrayList<Field>();
        for (Field field : arrField = cls.getDeclaredFields()) {
            int typeModifier = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(typeModifier)) continue;
            lsField.add(field);
        }
        return lsField;
    }

    public static List<String> getLsKey(Object obj) {
        ArrayList<String> ls = new ArrayList<String>();
        XReflect.getLsField(obj).forEach(field -> {
            String ele = field.getName();
            ls.add(ele);
        });
        return ls;
    }

    public static List<Object> getLsValue(Object obj) {
        ArrayList<Object> ls = new ArrayList<Object>();
        XReflect.getLsField(obj).forEach(field -> {
            try {
                Object ele = XReflect.get(obj, field);
                ls.add(ele);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        });
        return ls;
    }
}

