/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.schedule;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.schedule.XScheduleParam;

public final class XSchedule {
    private static final String ID_ZONE_VN_HCM = "Asia/Ho_Chi_Minh";
    private transient ScheduledExecutorService service;

    public XSchedule(String name) {
        XConfig config = new XConfig(name);
        Integer numThread = config.getInt("numThread");
        this.init(numThread);
    }

    public XSchedule() {
        this(1);
    }

    public XSchedule(int numThread) {
        this.init(numThread);
    }

    public void init(int numThread) {
        this.service = Executors.newScheduledThreadPool(numThread);
    }

    public int sizeQueue() {
        ScheduledThreadPoolExecutor poolThread = (ScheduledThreadPoolExecutor)this.service;
        return poolThread.getQueue().size();
    }

    public boolean shutdown() {
        return this.shutdown(Long.MAX_VALUE);
    }

    public boolean shutdown(long msWait) {
        try {
            this.service.shutdown();
            return this.service.awaitTermination(msWait, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public ScheduledFuture<?> scheduleDaily(XScheduleParam param) {
        ZonedDateTime nextRun;
        Integer sec;
        XEx.checkNotNull(param, "func", "hr");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(ID_ZONE_VN_HCM));
        Integer hr = param.getHr();
        Integer min = param.getMin();
        if (min == null) {
            min = 0;
        }
        if ((sec = param.getMin()) == null) {
            sec = 0;
        }
        if (now.compareTo(nextRun = now.withHour(hr).withMinute(min).withSecond(sec)) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        long initalDelay = duration.getSeconds();
        Runnable func = param.getFunc();
        return this.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(3600000L).msDelayInit(initalDelay).func(func).build());
    }

    public ScheduledFuture<?> scheduleHourly(XScheduleParam param) {
        ZonedDateTime nextRun;
        XEx.checkNotNull(param, "func", "min");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(ID_ZONE_VN_HCM));
        Integer min = param.getMin();
        Integer sec = param.getMin();
        if (sec == null) {
            sec = 0;
        }
        if (now.compareTo(nextRun = now.withMinute(min).withSecond(sec)) > 0) {
            nextRun = nextRun.plusHours(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        long initalDelay = duration.getSeconds();
        Runnable func = param.getFunc();
        return this.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(3600000L).msDelayInit(initalDelay).func(func).build());
    }

    public ScheduledFuture<?> scheduleAtFixedRate(XScheduleParam param) {
        XEx.checkNotNull(param, "func", "msPeriod");
        Long msPeriod = param.getMsPeriod();
        Long msDelayInit = param.getMsDelayInit();
        if (msDelayInit == null) {
            msDelayInit = 0L;
        }
        Runnable func = param.getFunc();
        return this.service.scheduleAtFixedRate(func::run, msDelayInit, msPeriod, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(XScheduleParam param) {
        XEx.checkNotNull(param, "func", "msDelay");
        Runnable func = param.getFunc();
        Long msDelay = param.getMsDelay();
        Long msDelayInit = param.getMsDelayInit();
        if (msDelayInit == null) {
            msDelayInit = 0L;
        }
        return this.service.scheduleWithFixedDelay(func::run, msDelayInit, msDelay, TimeUnit.MILLISECONDS);
    }
}

