/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.seq;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.xyou.xcommon.ex.XEx;

public final class XSeq {
    @SafeVarargs
    public static <V> V[] newArray(V ... arr) {
        return arr;
    }

    @SafeVarargs
    public static <V> List<V> newArrayList(V ... arrEle) {
        return Lists.newArrayList((Object[])arrEle);
    }

    @SafeVarargs
    public static <V> Set<V> newHashSet(V ... arrEle) {
        return Sets.newHashSet((Object[])arrEle);
    }

    public static <V> Set<V> newConcurrentHashSet() {
        return Sets.newConcurrentHashSet();
    }

    public static <V> Set<V> newConcurrentHashSe(Iterable<? extends V> elements) {
        return Sets.newConcurrentHashSet(elements);
    }

    public static boolean isEmpty(Object seq) {
        if (seq == null) {
            return true;
        }
        if (seq instanceof Collection) {
            Collection coll = (Collection)seq;
            return coll.isEmpty();
        }
        if (seq instanceof Object[]) {
            Object[] arr = (Object[])seq;
            return arr.length == 0;
        }
        throw XEx.createClassInvalid(seq);
    }

    public static <V> boolean isEmpty(Collection<V> coll) {
        return coll == null || coll.isEmpty();
    }

    public static <V> List<List<V>> partition(List<V> coll, int size) {
        return Lists.partition(coll, (int)size);
    }

    public static <V> List<V> subLs(List<V> ls, int idxStart, int count) {
        int sizeLs = ls.size();
        if (idxStart >= sizeLs || count < 0) {
            return new ArrayList();
        }
        count = count == 0 ? sizeLs : count;
        int startIndex = idxStart < 0 ? 0 : idxStart;
        int toIndex = startIndex + count < sizeLs ? startIndex + count : sizeLs;
        List<V> lsSub = ls.subList(startIndex, toIndex);
        return new ArrayList<V>(lsSub);
    }

    public static <V> List<V> subLs(List<V> ls, int sizeMax) {
        if (sizeMax == 0) {
            return new ArrayList();
        }
        List<V> lsSub = ls.size() > sizeMax ? ls.subList(0, sizeMax) : ls;
        lsSub = new ArrayList<V>(lsSub);
        return lsSub;
    }

    public static <V> void addNotNull(Collection<V> coll, V ele) {
        if (ele != null) {
            coll.add(ele);
        }
    }

    public static <V> List<V> shuffleLsTop(List<V> lsItem, int numTop) {
        ArrayList<V> lsData = new ArrayList<V>();
        List<V> lsTop = XSeq.subLs(lsItem, 0, numTop);
        List<V> lsRemain = XSeq.subLs(lsItem, numTop, lsItem.size());
        Collections.shuffle(lsTop);
        lsData.addAll(lsTop);
        lsData.addAll(lsRemain);
        return lsData;
    }

    public static <V> List<V> shuffleLsLsByLsWeight(List<List<V>> lsLs, List<Double> lsWeight, int sizePartition) {
        boolean isEmptyAllLs;
        if (XSeq.isEmpty(lsLs)) {
            throw new RuntimeException("lsLs must have data.");
        }
        if (XSeq.isEmpty(lsWeight)) {
            throw new RuntimeException("lsWeight must have data.");
        }
        if (lsLs.size() != lsWeight.size()) {
            throw new RuntimeException("lsWeight must be the same size as lsWeight.");
        }
        double weightTotal = XSeq.sum(lsWeight);
        if (Math.abs(weightTotal - 1.0) > 0.01) {
            throw new RuntimeException("The sum of lsWeight must be 1.");
        }
        if (sizePartition < 1) {
            throw new RuntimeException("Size partition must at least 1.");
        }
        List lsIndex = lsLs.stream().map(ele -> 0).collect(Collectors.toList());
        List lsStep = lsWeight.stream().map(weight -> (int)Math.ceil(weight * (double)sizePartition)).collect(Collectors.toList());
        ArrayList lsResult = new ArrayList();
        ArrayList<V> lsShuffled = new ArrayList<V>();
        do {
            isEmptyAllLs = true;
            lsShuffled.clear();
            for (int idx = 0; idx < lsLs.size(); ++idx) {
                List<V> lsData = lsLs.get(idx);
                int idxFrom = (Integer)lsIndex.get(idx);
                if (XSeq.isEmpty(lsData) || idxFrom >= lsData.size()) continue;
                isEmptyAllLs = false;
                int step = (Integer)lsStep.get(idx);
                int idxTo = idxFrom + step;
                idxTo = Math.min(idxTo, lsData.size());
                lsShuffled.addAll(lsData.subList(idxFrom, idxTo));
                lsIndex.set(idx, idxTo);
            }
            Collections.shuffle(lsShuffled);
            lsResult.addAll(lsShuffled);
        } while (!isEmptyAllLs);
        return lsResult;
    }

    public static <V extends Number> double sum(Collection<V> coll) {
        if (coll == null || coll.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (Number ele : coll) {
            result += ele.doubleValue();
        }
        return result;
    }

    public static <V> List<V> distinct(Collection<V> coll) {
        HashSet set = new HashSet();
        ArrayList lsDistinct = new ArrayList();
        coll.forEach(ele -> {
            if (set.contains(ele)) {
                return;
            }
            lsDistinct.add(ele);
            set.add(ele);
        });
        return lsDistinct;
    }

    public static <V> Collection<V> addEleToCollectionIfNotNull(Collection<V> coll, V ele) {
        if (ele != null) {
            coll.add(ele);
        }
        return coll;
    }

    public static <V, T> List<T> map(Collection<V> coll, Function<V, T> func) {
        return coll.stream().map(func).collect(Collectors.toList());
    }

    public static <V> V reduce(Collection<V> coll, BiFunction<V, V, V> func) {
        Iterator<V> iterator = coll.iterator();
        V data = iterator.next();
        while (iterator.hasNext()) {
            V ele = iterator.next();
            data = func.apply(data, ele);
        }
        return data;
    }
}

