/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.thread;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;

public final class XThreadPool
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer numThread;
    private Integer sizeQueueMax;
    private Boolean isProfiler;
    private transient ThreadPoolExecutor pool;
    private transient XProfilerObj objProfiler;

    public XThreadPool(Integer numThread, Integer sizeQueueMax) {
        this.name = null;
        this.numThread = numThread;
        this.sizeQueueMax = sizeQueueMax;
        this.isProfiler = false;
        this.pool = this.initPoolThread(numThread, sizeQueueMax);
        this.objProfiler = null;
    }

    public XThreadPool(String name) {
        XConfig config = new XConfig(name);
        this.name = name;
        this.numThread = config.getInt("numThread");
        this.sizeQueueMax = config.getInt("sizeQueueMax");
        this.isProfiler = config.getBool("isProfiler", false);
        this.pool = this.initPoolThread(this.numThread, this.sizeQueueMax);
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(this);
            this.objProfiler.scheduleGauge("size", this::sizeQueue);
        }
    }

    private ThreadPoolExecutor initPoolThread(int numThread, int sizeQueueMax) {
        LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>(sizeQueueMax);
        return new ThreadPoolExecutor(numThread, numThread, 60000L, TimeUnit.MILLISECONDS, queue);
    }

    public int sizeQueue() {
        return this.pool.getQueue().size();
    }

    public boolean submit(Runnable func) {
        this.pool.submit(func::run);
        return true;
    }

    public boolean shutdown() {
        return this.shutdown(Long.MAX_VALUE);
    }

    public boolean shutdown(long msWait) {
        try {
            this.pool.shutdown();
            return this.pool.awaitTermination(msWait, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public Integer getSizeQueueMax() {
        return this.sizeQueueMax;
    }

    public Boolean getIsProfiler() {
        return this.isProfiler;
    }
}

