/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.tool;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.tool.XStr;

public final class XCvt {
    public static String toStr(Object in) {
        return XCvt.toStr(in, null);
    }

    public static String toStr(Object in, String def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof Timestamp) {
                return Long.toString(((Timestamp)in).getTime() / 1000L);
            }
            if (in instanceof Collection) {
                StringJoiner joiner = new StringJoiner(",");
                ((Collection)in).forEach(ele -> joiner.add(ele.toString()));
                return joiner.toString();
            }
            if (in instanceof Object[]) {
                try {
                    return XCvt.toStr(XSeq.newArrayList((Object[])in));
                }
                catch (Throwable throwable) {
                    return "";
                }
            }
            return in.toString();
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Integer toInt(Object in) {
        return XCvt.toInt(in, null);
    }

    public static Integer toInt(Object in, Integer def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inTrim = ((String)in).trim();
                try {
                    return Integer.parseInt(inTrim);
                }
                catch (Throwable throwable) {
                    return XCvt.toInt(Double.parseDouble(inTrim));
                }
            }
            return ((Number)in).intValue();
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Long toLong(Object in) {
        return XCvt.toLong(in, null);
    }

    public static Long toLong(Object in, Long def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inTrim = ((String)in).trim();
                try {
                    return Long.parseLong(inTrim);
                }
                catch (Throwable throwable) {
                    return XCvt.toLong(Double.parseDouble(inTrim));
                }
            }
            return ((Number)in).longValue();
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Float toFloat(Object in) {
        return XCvt.toFloat(in, null);
    }

    public static Float toFloat(Object in, Float def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                return Float.valueOf(Float.parseFloat(((String)in).trim()));
            }
            return Float.valueOf(((Number)in).floatValue());
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Double toDouble(Object in) {
        return XCvt.toDouble(in, null);
    }

    public static Double toDouble(Object in, Double def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                return Double.parseDouble(((String)in).trim());
            }
            return ((Number)in).doubleValue();
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Boolean toBool(Object in) {
        return XCvt.toBool(in, null);
    }

    public static Boolean toBool(Object in, Boolean def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inProcess = ((String)in).trim();
                if (inProcess.equals("true")) {
                    return true;
                }
                if (inProcess.equals("false")) {
                    return false;
                }
            }
            return (Boolean)in;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Timestamp toTimestamp(Object in) {
        return XCvt.toTimestamp(in, null);
    }

    public static Timestamp toTimestamp(Object in, Timestamp def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof Number) {
                return new Timestamp(((Number)in).longValue() * 1000L);
            }
            return (Timestamp)in;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<String> toLsStr(Object in) {
        return XCvt.toLsStr(in, null);
    }

    public static List<String> toLsStr(Object in, List<String> def) {
        try {
            if (in == null) {
                return def;
            }
            ArrayList<String> lsData = new ArrayList<String>();
            if (in instanceof String) {
                String strLs = (String)in;
                String[] arrEle = null;
                arrEle = strLs.contains(",") ? strLs.split(",") : XSeq.newArray(strLs);
                for (String ele2 : arrEle) {
                    try {
                        if (XStr.isEmpty(ele2)) continue;
                        lsData.add(ele2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return lsData;
            }
            if (in instanceof Object[]) {
                for (Object ele3 : (Object[])in) {
                    lsData.add(XCvt.toStr(ele3));
                }
                return lsData;
            }
            ((Collection)in).forEach(ele -> lsData.add(XCvt.toStr(ele)));
            return lsData;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<Integer> toLsInt(Object in) {
        return XCvt.toLsInt(in, null);
    }

    public static List<Integer> toLsInt(Object in, List<Integer> def) {
        try {
            if (in == null) {
                return def;
            }
            ArrayList<Integer> lsData = new ArrayList<Integer>();
            if (in instanceof int[]) {
                for (int ele : (int[])in) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = XCvt.toLsStr(in);
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(lsData, XCvt.toInt(eleStr));
                }
                catch (Throwable throwable) {}
            }
            return lsData;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<Long> toLsLong(Object in) {
        return XCvt.toLsLong(in, null);
    }

    public static List<Long> toLsLong(Object in, List<Long> def) {
        try {
            if (in == null) {
                return def;
            }
            ArrayList<Long> lsData = new ArrayList<Long>();
            if (in instanceof long[]) {
                for (long ele : (long[])in) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = XCvt.toLsStr(in);
            lsStr.forEach(eleStr -> {
                try {
                    XSeq.addEleToCollectionIfNotNull(lsData, XCvt.toLong(eleStr));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            return lsData;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<Float> toLsFloat(Object in) {
        return XCvt.toLsFloat(in, null);
    }

    public static List<Float> toLsFloat(Object in, List<Float> def) {
        try {
            if (in == null) {
                return def;
            }
            ArrayList<Float> lsData = new ArrayList<Float>();
            if (in instanceof float[]) {
                for (float ele : (float[])in) {
                    lsData.add(Float.valueOf(ele));
                }
                return lsData;
            }
            List<String> lsStr = XCvt.toLsStr(in);
            lsStr.forEach(eleStr -> {
                try {
                    XSeq.addEleToCollectionIfNotNull(lsData, XCvt.toFloat(eleStr));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            return lsData;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<Double> toLsDouble(Object in) {
        return XCvt.toLsDouble(in, null);
    }

    public static List<Double> toLsDouble(Object in, List<Double> def) {
        try {
            if (in == null) {
                return def;
            }
            ArrayList<Double> lsData = new ArrayList<Double>();
            if (in instanceof double[]) {
                for (double ele : (double[])in) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = XCvt.toLsStr(in);
            lsStr.forEach(eleStr -> {
                try {
                    XSeq.addEleToCollectionIfNotNull(lsData, XCvt.toDouble(eleStr));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            return lsData;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static List<Boolean> toLsBool(Object in) {
        return XCvt.toLsBool(in, null);
    }

    public static List<Boolean> toLsBool(Object in, List<Boolean> def) {
        try {
            if (in == null) {
                return def;
            }
            List<String> lsStr = XCvt.toLsStr(in);
            ArrayList<Boolean> ls = new ArrayList<Boolean>();
            lsStr.forEach(eleStr -> {
                try {
                    XSeq.addEleToCollectionIfNotNull(ls, XCvt.toBool(eleStr));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            return ls;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static <V> List<V> toLsObject(V[] arr) {
        return XCvt.toLsObject(arr, null);
    }

    public static <V> List<V> toLsObject(V[] arr, List<V> def) {
        try {
            if (arr == null) {
                return def;
            }
            return Arrays.asList(arr);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Set<String> toSetStr(Object in) {
        return XCvt.toSetStr(in, null);
    }

    public static Set<String> toSetStr(Object in, Set<String> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<String>(XCvt.toLsStr(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Set<Integer> toSetInt(Object in) {
        return XCvt.toSetInt(in, null);
    }

    public static Set<Integer> toSetInt(Object in, Set<Integer> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<Integer>(XCvt.toLsInt(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Set<Long> toSetLong(Object in) {
        return XCvt.toSetLong(in, null);
    }

    public static Set<Long> toSetLong(Object in, Set<Long> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<Long>(XCvt.toLsLong(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Set<Double> toSetDouble(Object in) {
        return XCvt.toSetDouble(in, null);
    }

    public static Set<Double> toSetDouble(Object in, Set<Double> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<Double>(XCvt.toLsDouble(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Set<Float> toSetFloat(Object in) {
        return XCvt.toSetFloat(in, null);
    }

    public static Set<Float> toSetFloat(Object in, Set<Float> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<Float>(XCvt.toLsFloat(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static Set<Boolean> toSetBool(Object in) {
        return XCvt.toSetBool(in, null);
    }

    public static Set<Boolean> toSetBool(Object in, Set<Boolean> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<Boolean>(XCvt.toLsBool(in));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static <V> V[] toArray(Collection<V> coll) {
        return XCvt.toArray(coll, null);
    }

    public static <V> V[] toArray(Collection<V> coll, V[] def) {
        try {
            if (coll == null) {
                return def;
            }
            Class<?> cls = coll.iterator().next().getClass();
            Object[] arrType = (Object[])Array.newInstance(cls, 0);
            return coll.toArray(arrType);
        }
        catch (Throwable throwable) {
            return def;
        }
    }
}

