/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.tool;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.schedule.XSchedule;
import org.xyou.xcommon.schedule.XScheduleParam;

public final class XDestructor
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private static final transient XLogger LOGGER = new XLogger();
    private Boolean isCancel = false;
    private static transient XSchedule schedule;

    public XDestructor(long msMax) {
        long timeStart = System.currentTimeMillis();
        schedule = new XSchedule();
        schedule.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(1000L).func(() -> {
            long timeCur = System.currentTimeMillis();
            long msPassed = timeCur - timeStart;
            if (msPassed > msMax) {
                LOGGER.info("Process self-destructed");
                System.exit(-1);
            }
        }).build());
        LOGGER.info("Destructor started");
    }

    public void cancel() {
        if (!this.isCancel.booleanValue()) {
            schedule.shutdown();
            this.isCancel = true;
            LOGGER.info("Destructor cancel");
        } else {
            LOGGER.info("Destructor has been cancelled");
        }
    }

    public Boolean getIsCancel() {
        return this.isCancel;
    }
}

