/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.tool;

import java.util.function.BiFunction;
import java.util.function.Function;

public final class XMl {
    public static double computeLengthManhattan(double[] vec) {
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            sum += vec[i];
        }
        return sum;
    }

    public static double computeLengthEuclid(double[] vec) {
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            double value = vec[i];
            sum += value * value;
        }
        return Math.sqrt(sum);
    }

    public static double[] normalize(double[] arrInput, double[] arrOutput, Function<double[], Double> computeLength) {
        double normValue = computeLength.apply(arrInput);
        for (int idxEle = 0; idxEle < arrInput.length; ++idxEle) {
            arrOutput[idxEle] = arrInput[idxEle] / normValue;
        }
        return arrOutput;
    }

    public static double[] normalizeL1(double[] arr) {
        return XMl.normalize(arr, new double[arr.length], ele -> XMl.computeLengthManhattan(ele));
    }

    public static double[] normalizeL1InPlace(double[] arr) {
        return XMl.normalize(arr, arr, ele -> XMl.computeLengthManhattan(ele));
    }

    public static double[] normalizeL2(double[] arr) {
        return XMl.normalize(arr, new double[arr.length], ele -> XMl.computeLengthEuclid(ele));
    }

    public static double[] normalizeL2InPlace(double[] arr) {
        return XMl.normalize(arr, arr, ele -> XMl.computeLengthEuclid(ele));
    }

    public static double sigmoid(double inpt) {
        return 1.0 / (1.0 + Math.exp(-inpt));
    }

    public static double tanh(double inpt) {
        return 2.0 / (1.0 + Math.exp(-2.0 * inpt)) - 1.0;
    }

    public static int argMax(double[] arr) {
        double valMax = -4.9E-324;
        int idxMax = 0;
        for (int idx = 0; idx < arr.length; ++idx) {
            double val = arr[idx];
            if (!(val > valMax)) continue;
            idxMax = idx;
            valMax = val;
        }
        return idxMax;
    }

    public static double dot(double[] arr1, double[] arr2) {
        double product = 0.0;
        int length = arr1.length;
        for (int i = 0; i < length; ++i) {
            double eleA = arr1[i];
            double eleB = arr2[i];
            product += eleA * eleB;
        }
        return product;
    }

    private static double[] computeVector(double[] arrRes, double[] arr1, double[] arr2, BiFunction<Double, Double, Double> op) {
        for (int idxEle = 0; idxEle < arr1.length; ++idxEle) {
            arrRes[idxEle] = op.apply(arr1[idxEle], arr2[idxEle]);
        }
        return arrRes;
    }

    public static double[] add(double[] arr1, double[] arr2) {
        double[] arrRes = new double[arr1.length];
        return XMl.computeVector(arrRes, arr1, arr2, (ele1, ele2) -> ele1 + ele2);
    }

    public static double[] addInPlace(double[] arr1, double[] arr2) {
        return XMl.computeVector(arr1, arr1, arr2, (ele1, ele2) -> ele1 + ele2);
    }

    public static double[] mul(double[] arr1, double[] arr2) {
        double[] arrRes = new double[arr1.length];
        return XMl.computeVector(arrRes, arr1, arr2, (ele1, ele2) -> ele1 * ele2);
    }

    public static double[] mulInPlace(double[] arr1, double[] arr2) {
        return XMl.computeVector(arr1, arr1, arr2, (ele1, ele2) -> ele1 * ele2);
    }

    public static double[] sub(double[] arr1, double[] arr2) {
        double[] arrRes = new double[arr1.length];
        return XMl.computeVector(arrRes, arr1, arr2, (ele1, ele2) -> ele1 - ele2);
    }

    public static double[] subInPlace(double[] arr1, double[] arr2) {
        return XMl.computeVector(arr1, arr1, arr2, (ele1, ele2) -> ele1 - ele2);
    }

    public static double[] div(double[] arr1, double[] arr2) {
        double[] arrRes = new double[arr1.length];
        return XMl.computeVector(arrRes, arr1, arr2, (ele1, ele2) -> ele1 / ele2);
    }

    public static double[] divInPlace(double[] arr1, double[] arr2) {
        return XMl.computeVector(arr1, arr1, arr2, (ele1, ele2) -> ele1 / ele2);
    }
}

