/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.tool;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class XTime {
    public static final String FM_SLASH_YM = "yyyy/MM";
    public static final String FM_SLASH_YMD = "yyyy/MM/dd";
    public static final String FM_SLASH_YMDH = "yyyy/MM/dd/HH";
    public static final String FM_SLASH_YMDHM = "yyyy/MM/dd/HH/mm";
    public static final String FM_SLASH_YMDHMS = "yyyy/MM/dd/HH/mm/ss";
    public static final String FM_HYPHEN_YMD = "yyyy-MM-dd";
    public static final String FM_HYPHEN_YMDH = "yyyy-MM-dd-HH";
    public static final String FM_HYPHEN_YMDHM = "yyyy-MM-dd-HH-mm";
    public static final String FM_HYPHEN_YMDHMS = "yyyy-MM-dd-HH-mm-ss";
    public static final String FM_YMD = "yyyyMMdd";
    public static final String FM_YMDH = "yyyyMMddHH";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final long SEC_MIN = 60L;
    public static final long SEC_HR = 3600L;
    public static final long SEC_DAY = 86400L;
    public static final long SEC_WEEK = 604800L;
    public static final long SEC_MONTH = 2592000L;
    public static final long SEC_YEAR = 31536000L;
    public static final long MS_SEC = 1000L;
    public static final long MS_MIN = 60000L;
    public static final long MS_HR = 3600000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_WEEK = 604800000L;
    public static final long MS_MONTH = 2592000000L;
    public static final long MS_YEAR = 31536000000L;
    public static final long US_SEC = 1000000L;
    public static final long US_MIN = 60000000L;
    public static final long US_HR = 3600000L;
    public static final long US_DAY = 86400000L;
    public static final long US_WEEK = 604800000L;
    public static final long US_MONTH = 2592000000L;
    public static final long US_YEAR = 31536000000L;
    public static final long NS_US = 1000L;
    public static final long NS_MS = 1000000L;
    public static final long NS_SEC = 1000000000L;
    public static final long NS_MIN = 60000000000L;
    public static final long NS_HR = 3600000000000L;
    public static final long NS_DAY = 86400000000000L;
    public static final long NS_WEEK = 604800000000000L;
    public static final long NS_MONTH = 2592000000000000L;
    public static final long NS_YEAR = 31536000000000000L;
    public static final Long TIME_START = XTime.getCurMs();
    public static final String TIME_START_SLASH_YMD = XTime.toStrMs(TIME_START, "yyyy/MM/dd");
    public static final String TIME_START_SLASH_YMDH = XTime.toStrMs(TIME_START, "yyyy/MM/dd/HH");
    public static final String TIME_START_HYPHEN_YMDHMS = XTime.toStrMs(TIME_START, "yyyy-MM-dd-HH-mm-ss");

    public static long truncate(long timestamp, long timestampRef) {
        return timestamp / timestampRef;
    }

    public static long round(long timestamp, long timestampRef) {
        return XTime.truncate(timestamp, timestampRef) * timestampRef;
    }

    public static long normWeekSec(long timestampSec) {
        return XTime.normWeekSec(timestampSec, 0L);
    }

    public static long normWeekSec(long timestampSec, long timestampRefSec) {
        return XTime.normWeekMs(timestampSec * 1000L, timestampRefSec * 1000L) / 1000L;
    }

    public static long normWeekMs(long timestampMs) {
        return XTime.normWeekMs(timestampMs, 0L);
    }

    public static long normWeekMs(long timestampMs, long timestampRefMs) {
        long timeNorm = timestampMs % 604800000L;
        long timeRefNorm = timestampRefMs % 604800000L;
        if (timeNorm < timeRefNorm) {
            timeNorm += 604800000L;
        }
        return timeNorm;
    }

    public static long getCurMs() {
        return System.currentTimeMillis();
    }

    public static long getCurSec() {
        return XTime.getCurMs() / 1000L;
    }

    public static Long fromStrMs(String timeStr, String format) {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(format);
            Date date = dateFormatter.parse(timeStr);
            long timestamp = date.getTime();
            return timestamp;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Long fromStrSec(String timeStr, String format) {
        try {
            return XTime.fromStrMs(timeStr, format) / 1000L;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String toStrMs(long timestampMs, String format) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date date = new Date(timestampMs);
            String timeStr = formatter.format(date);
            return timeStr;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String toStrSec(long timestampSec, String format) {
        try {
            return XTime.toStrMs(timestampSec * 1000L, format);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

