/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.txt;

import java.io.FileWriter;
import java.util.List;
import java.util.StringJoiner;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.file.XFile;

public final class XTxtWriter
extends XBaseObject
implements AutoCloseable {
    private static final long serialVersionUID = 1L;
    private String path;
    private FileWriter writer;

    public XTxtWriter(String path) {
        try {
            this.path = path;
            String pathDirParent = XFile.dirname(path);
            XFile.mkdir(pathDirParent);
            this.writer = new FileWriter(path);
        }
        catch (Throwable ex) {
            new RuntimeException(ex);
        }
    }

    public static void writeAll(String path) {
        XTxtWriter.writeAll(path, "");
    }

    public static void writeAll(String path, Object obj) {
        try (XTxtWriter writer = new XTxtWriter(path);){
            writer.write(obj.toString());
        }
    }

    public boolean writeLine(List<Object> lsObj) {
        StringJoiner joiner = new StringJoiner("\t");
        lsObj.stream().forEach(ele -> joiner.add(ele.toString()));
        return this.writeLine(joiner);
    }

    public boolean writeLine(Object obj) {
        return this.write(obj, "\n");
    }

    public boolean write(Object obj) {
        return this.write(obj, "");
    }

    public boolean write(Object obj, String suffix) {
        try {
            this.writer.write(obj.toString() + suffix);
            return true;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.close();
            this.writer = null;
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public String getPath() {
        return this.path;
    }
}

