package org.xyou.xcommon.cls;

import lombok.NonNull;

public final class XCls {

    public static Class<?> getClassByTrace(@NonNull Integer idxTrace) {
        return XCls.getClassByNameClass(
            new Exception().getStackTrace()[idxTrace + 1]
                .getClassName()
        );
    }

    public static Class<?> getClass(@NonNull Object obj) {
        if (obj instanceof Class) {
            return (Class<?>) obj;
        }
        return obj.getClass();
    }

    public static Class<?> getClassByNameClass(@NonNull String nameClass) {
        try {
            return Class.forName(nameClass);
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Boolean is(@NonNull Object obj, @NonNull Class<?> cls) {
        return getClass(obj).isAssignableFrom(cls);
    }

    public static Boolean isByte(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Byte.class) || is(cls, byte.class);
    }

    public static Boolean isInt(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Integer.class) || is(cls, int.class);
    }

    public static Boolean isLong(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Long.class) || is(cls, long.class);
    }

    public static Boolean isFloat(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Float.class) || is(cls, float.class);
    }

    public static Boolean isDouble(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Double.class) || is(cls, double.class);
    }

    public static Boolean isBool(@NonNull Object obj) {
        Class<?> cls = getClass(obj);
        return is(cls, Boolean.class) || is(cls, boolean.class);
    }

}
