package org.xyou.xcommon.codec;

import java.security.spec.KeySpec;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

import org.xyou.xcommon.str.XStr;

import lombok.AccessLevel;
import lombok.Getter;

final class Model {

    private final Cipher encryptorId;
    private final Cipher decryptorId;
    @Getter(AccessLevel.PACKAGE)
    private final String prefix;

    private static class Holder {

        public static final ThreadLocal<Model> INST = ThreadLocal.withInitial(Model::new);

    }

    static Model getInst() {
        return Holder.INST.get();
    }

    private Model() {
        prefix = "x-";
        Cipher encryptorId = null;
        Cipher decryptorId = null;
        try {
            String secretKey = "GY2/6i=d602PC)iU";
            String salt = "]FUKKn*Rtpc5O}Kj";
            byte[] iv = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            KeySpec spec = new PBEKeySpec(secretKey.toCharArray(), salt.getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(tmp.getEncoded(), "AES");
            encryptorId = Cipher.getInstance("AES/CBC/PKCS5Padding");
            encryptorId.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivSpec);
            decryptorId = Cipher.getInstance("AES/CBC/PKCS5Padding");
            decryptorId.init(Cipher.DECRYPT_MODE, secretKeySpec, ivSpec);
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        this.encryptorId = encryptorId;
        this.decryptorId = decryptorId;
    }

    String encode(String strToEncrypt) {
        try {
            return XStr.encodeBase64(encryptorId.doFinal(strToEncrypt.getBytes("UTF-8")));
        } catch (Throwable ex) {
        }
        return null;
    }

    String decode(String strToDecrypt) {
        try {
            if (XStr.isEmpty(strToDecrypt)) {
                return null;
            }
            return new String(decryptorId.doFinal(XStr.decodeBase64(strToDecrypt)));
        } catch (Throwable ex) {
        }
        return null;
    }

}
