package org.xyou.xcommon.codec;

import java.util.List;
import java.util.stream.Collectors;

import org.xyou.xcommon.ser.XSer;
import org.xyou.xcommon.str.XStr;

import lombok.NonNull;

public final class XCodec {

    public static boolean isValidId(Object id) {
        if (id instanceof String) {
            return true;
        }
        if (id instanceof Number) {
            Long idLong = ((Number) id).longValue();
            if (idLong < 1l) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> encodeIdInt(List<Integer> lsId, @NonNull Integer salt) {
        try {
            return lsId.stream()
                .map(id -> encodeIdInt(id, salt))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<String> encodeIdLong(List<Long> lsId, @NonNull Integer salt) {
        try {
            return lsId.stream()
                .map(id -> encodeIdLong(id, salt))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<Integer> decodeIdInt(List<String> lsId, @NonNull Integer salt) {
        try {
            return lsId.stream()
                .map(id -> decodeIdInt(id, salt))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;

    }

    public static List<Long> decodeIdLong(List<String> lsId, @NonNull Integer salt) {
        try {
            return lsId.stream()
                .map(id -> decodeIdLong(id, salt))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static String encodeIdLong(Long id, @NonNull Integer salt) {
        if (!isValidId(id)) {
            return null;
        }
        byte[] arrByte = XSer.serialize(id ^ salt);
        return encodeIdByte(arrByte);
    }

    public static String encodeIdInt(Integer id, @NonNull Integer salt) {
        if (!isValidId(id)) {
            return null;
        }
        byte[] arrByte = XSer.serialize(id ^ salt);
        return encodeIdByte(arrByte);
    }

    public static String encodeIdByte(byte[] id) {
        String encoded = XStr.encodeBase64(id);
        encoded = Model.getInst().encode(encoded);
        String encodedNoPad = encoded.substring(0, encoded.length() - 2);
        return Model.getInst().getPrefix() + encodedNoPad;
    }

    public static Long decodeIdLong(String idEncoded, @NonNull Integer salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return XSer.toLong(arrByte) ^ salt;
    }

    public static Integer decodeIdInt(String idEncoded, @NonNull Integer salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return XSer.toInt(arrByte) ^ salt;
    }

}
