package org.xyou.xcommon.config;

import java.net.JarURLConnection;
import java.util.Collections;
import java.util.jar.JarFile;

import org.ini4j.Wini;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.url.XUrl;
import org.xyou.xcommon.yaml.XYaml;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NonNull;

final class XConfigModel {

    private final transient XLogger logger;
    @Getter(AccessLevel.PACKAGE)
    private final transient XObj mapSection;

    private static class Holder {

        public static final XConfigModel INST = new XConfigModel();
    }

    static XConfigModel getInst() {
        return Holder.INST;
    }

    private XConfigModel() {
        logger = new XLogger();
        mapSection = new XObj();
        try {
            Collections.list(ClassLoader.getSystemResources("conf/production.config.ini")).forEach(url -> {
                try {
                    logger.info("Read ini " + url.getPath());
                    new Wini(url).entrySet().forEach(entrySection -> {
                        XObj section = new XObj();
                        entrySection.getValue().entrySet().forEach(entry -> {
                            section.put(entry.getKey(), entry.getValue());
                        });
                        put(entrySection.getKey(), section);
                    });
                } catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
            String nameDir = "xconfig";
            Collections.list(ClassLoader.getSystemResources(nameDir)).forEach(urlDir -> {
                try {
                    String pathDir = urlDir.getPath();
                    logger.info("At " + pathDir);
                    if (XFile.exist(pathDir)) {
                        XFile.ls(pathDir).forEach(name -> addConfig(pathDir + "/" + name));
                    } else {
                        try (JarFile file = ((JarURLConnection) urlDir.openConnection()).getJarFile()) {
                            Collections.list(file.entries()).forEach(ele -> {
                                String name = ele.getName();
                                if (!XFile.basename(XFile.dirname(name)).equals(nameDir)) {
                                    return;
                                }
                                addConfig(XUrl.init(urlDir + "/" + XFile.basename(name)));
                            });

                        }
                    }
                } catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
        } catch (Throwable ex) {
            logger.error(ex);
        }
    }

    private void addConfig(@NonNull Object url) {
        try {
            logger.info("Read " + url);
            XYaml.fromFile(url, XObj.class).getMap().entrySet().forEach(entrySection -> {
                put(entrySection.getKey(), entrySection.getValue());
            });
        } catch (Throwable ex) {
            logger.error("Read fail " + url);
            logger.error(ex);
        }
    }

    private void put(@NonNull Object key, @NonNull Object section) {
        if (mapSection.containsKey(key)) {
            logger.info("Overwrite section " + key);
        } else {
            logger.info("Read section " + key);
        }
        mapSection.put(key, section);
    }

}
