package org.xyou.xcommon.console;

import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.time.XTime;

public final class XConsole {

    public static void info(Object obj) {
        log(obj);
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable cause = (Throwable) obj;
            log(cause.getMessage());
            cause.printStackTrace();
        } else {
            log(obj);
        }
    }

    private static synchronized void log(Object obj) {
        StackTraceElement[] arrEleStackTrace = new Exception().getStackTrace();
        StackTraceElement eleStackTrace = arrEleStackTrace[2];
        System.out.println(
            String.format(
                "%s %-5s [%s@%s:%s] - %s",
                XTime.toStrMs(
                    XTime.getCurMs(),
                    XTime.FM_DATE_TIME
                ),
                arrEleStackTrace[1].getMethodName()
                    .toUpperCase(),
                Thread.currentThread()
                    .getName(),
                XCls.getClassByNameClass(eleStackTrace.getClassName())
                    .getSimpleName(),
                eleStackTrace.getLineNumber(),
                obj
            )
        );
    }

}
