package org.xyou.xcommon.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.seq.XSeq;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
public final class XLs<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    public static final XLs<?> EMPTY = new XLs<>();

    private Integer total;
    private List<V> lsData;

    public XLs() {
        init(new ArrayList<>());
    }

    public XLs(@NonNull V data) {
        init(XSeq.newArrayList(data));
    }

    public XLs(@NonNull List<V> lsData) {
        init(lsData);
    }

    public XLs(@NonNull XLs<V> xLs, @NonNull Integer idxStart, @NonNull Integer count) {
        init(xLs.getLsData(), idxStart, count);
    }

    public XLs(List<V> lsData, int idxStart, int count) {
        init(lsData, idxStart, count);
    }

    private void init(@NonNull List<V> lsData) {
        init(lsData, 0, lsData.size());
    }

    private void init(@NonNull List<V> lsData, @NonNull Integer idxStart, @NonNull Integer count) {
        this.lsData = Collections.unmodifiableList(
            XSeq.subLs(lsData, idxStart, count)
        );
        total = lsData.size();
    }
}
