package org.xyou.xcommon.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.yaml.XJson;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;

@Getter
@EqualsAndHashCode(callSuper = true)
public final class XObj extends XBaseObject {

    private static final long serialVersionUID = 1L;

    private final Map<Object, Object> map;

    public XObj() {
        map = new LinkedHashMap<>();
    }

    public static XObj fromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return XJson.fromStr((String) obj, XObj.class);
        }
        if (obj instanceof XObj || obj instanceof Map) {
            return new XObj().putAll(obj);
        }
        return fromObject(XJson.toStr(obj));
    }

    public static boolean isEmpty(XObj obj) {
        if (obj == null) {
            return true;
        }
        if (XMap.isEmpty(obj.getMap())) {
            return true;
        }
        return false;
    }

    public Set<Object> keySet() {
        return map.keySet();
    }

    public Collection<Object> values() {
        return map.values();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return map.entrySet();
    }

    public boolean containsKey(@NonNull Object key) {
        return map.containsKey(key);
    }

    public XObj remove(@NonNull Object key) {
        map.remove(key);
        return this;
    }

    public XObj put(@NonNull Object key, Object value) {
        map.put(key, value);
        return this;
    }

    public XObj putAll(@NonNull Object obj) {
        if (obj instanceof XObj) {
            return putAll(((XObj) obj).getMap());
        }
        if (obj instanceof Map) {
            @SuppressWarnings("unchecked")
            Map<Object, Object> mapCast = (Map<Object, Object>) obj;
            map.putAll(mapCast);
            return this;
        }
        throw XEx.createClassInvalid(obj);
    }

    public <V> XObj filterByLsKey(@NonNull List<Object> lsKey) {
        XObj obj = new XObj();
        lsKey.forEach(key -> {
            if (!this.containsKey(key)) {
                return;
            }
            V value = get(key);
            obj.put(key, value);
        });
        return obj;
    }

    public <V> V get(@NonNull Object key) {
        return get(key, null);
    }

    public <V> V get(@NonNull Object key, V def) {
        try {
            @SuppressWarnings("unchecked")
            V value = (V) map.getOrDefault(key, def);
            return value;
        } catch (Throwable ex) {
        }
        return def;
    }

    public XObj getXObj(@NonNull Object key) {
        return getXObj(key, null);
    }

    public XObj getXObj(@NonNull Object key, XObj def) {
        try {
            Object value = get(key);
            if (value == null) {
                return def;
            }
            return new XObj().putAll(value);
        } catch (Throwable ex) {
        }
        return def;
    }

    public String getStr(@NonNull Object key) {
        return getStr(key, null);
    }

    public String getStr(@NonNull Object key, String def) {
        return XCvt.toStr(get(key), def);
    }

    public Integer getInt(@NonNull Object key) {
        return getInt(key, null);
    }

    public Integer getInt(@NonNull Object key, Integer def) {
        return XCvt.toInt(get(key), def);
    }

    public Long getLong(@NonNull Object key) {
        return getLong(key, null);
    }

    public Long getLong(@NonNull Object key, Long def) {
        return XCvt.toLong(get(key), def);
    }

    public Float getFloat(@NonNull Object key) {
        return getFloat(key, null);
    }

    public Float getFloat(@NonNull Object key, Float def) {
        return XCvt.toFloat(get(key), def);
    }

    public Double getDouble(@NonNull Object key) {
        return getDouble(key, null);
    }

    public Double getDouble(@NonNull Object key, Double def) {
        return XCvt.toDouble(get(key), def);
    }

    public Boolean getBool(@NonNull Object key) {
        return getBool(key, null);
    }

    public Boolean getBool(@NonNull Object key, Boolean def) {
        return XCvt.toBool(get(key), def);
    }

    public Timestamp getTimestamp(@NonNull Object key) {
        return getTimestamp(key, null);
    }

    public Timestamp getTimestamp(@NonNull Object key, Timestamp def) {
        return XCvt.toTimestamp(get(key), def);
    }

    public List<XObj> getLsObj(@NonNull Object key) {
        return getLsObj(key, null);
    }

    public List<XObj> getLsObj(@NonNull Object key, List<XObj> def) {
        try {
            List<Object> lsObject = get(key);
            List<XObj> lsObj = new ArrayList<>();
            lsObject.forEach(obj -> {
                try {
                    @SuppressWarnings("unchecked")
                    Map<Object, Object> value = (Map<Object, Object>) obj;
                    if (value == null) {
                        return;
                    }
                    lsObj.add(new XObj().putAll(value));
                } catch (Throwable ex) {
                }
            });
            return lsObj;
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<String> getLsStr(@NonNull Object key) {
        return getLsStr(key, null);
    }

    public List<String> getLsStr(@NonNull Object key, List<String> def) {
        return XCvt.toLsStr(get(key), def);
    }

    public List<Integer> getLsInt(@NonNull Object key) {
        return getLsInt(key, null);
    }

    public List<Integer> getLsInt(@NonNull Object key, List<Integer> def) {
        return XCvt.toLsInt(get(key), def);
    }

    public List<Long> getLsLong(@NonNull Object key) {
        return getLsLong(key, null);
    }

    public List<Long> getLsLong(@NonNull Object key, List<Long> def) {
        return XCvt.toLsLong(get(key), def);
    }

    public List<Float> getLsFloat(@NonNull Object key) {
        return getLsFloat(key, null);
    }

    public List<Float> getLsFloat(@NonNull Object key, List<Float> def) {
        return XCvt.toLsFloat(get(key), def);
    }

    public List<Double> getLsDouble(@NonNull Object key) {
        return getLsDouble(key, null);
    }

    public List<Double> getLsDouble(Object key, List<Double> def) {
        return XCvt.toLsDouble(get(key), def);
    }

    public Set<String> getSetStr(@NonNull Object key) {
        return getSetStr(key, null);
    }

    public Set<String> getSetStr(@NonNull Object key, Set<String> def) {
        return XCvt.toSetStr(get(key), def);
    }

    public Set<Integer> getSetInt(@NonNull Object key) {
        return getSetInt(key, null);
    }

    public Set<Integer> getSetInt(@NonNull Object key, Set<Integer> def) {
        return XCvt.toSetInt(get(key), def);
    }

    public Set<Long> getSetLong(@NonNull Object key) {
        return getSetLong(key, null);
    }

    public Set<Long> getSetLong(@NonNull Object key, Set<Long> def) {
        return XCvt.toSetLong(get(key), def);
    }

    public Set<Float> getSetFloat(@NonNull Object key) {
        return getSetFloat(key, null);
    }

    public Set<Float> getSetFloat(@NonNull Object key, Set<Float> def) {
        return XCvt.toSetFloat(get(key), def);
    }

    public Set<Double> getSetDouble(@NonNull Object key) {
        return getSetDouble(key, null);
    }

    public Set<Double> getSetDouble(@NonNull Object key, Set<Double> def) {
        return XCvt.toSetDouble(get(key), def);
    }

}
