package org.xyou.xcommon.ex;

import java.util.Set;

import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.reflect.XReflect;
import org.xyou.xcommon.seq.XSeq;

import lombok.NonNull;

public final class XEx {

    public static RuntimeException createClassInvalid(@NonNull Object obj) throws RuntimeException {
        return new RuntimeException("Class invalid " + XCls.getClass(obj).getName());
    }

    public static RuntimeException createNull(@NonNull String name) throws RuntimeException {
        throw new RuntimeException(String.format("'%s' null", name));
    }

    public static Object checkNotNull(@NonNull Object obj, @NonNull String... arrNameField) {
        if (obj instanceof XObj) {
            XObj objX = (XObj) obj;
            for (String nameField : arrNameField) {
                if (objX.get(nameField) == null) {
                    throw createNull(nameField);
                }
            }
            return obj;
        }
        Set<String> setNameField = XSeq.newHashSet(arrNameField);
        XReflect.getLsField(obj).forEach(field -> {
            String nameField = field.getName();
            if (!setNameField.contains(nameField)) {
                return;
            }
            if (XReflect.get(obj, field) == null) {
                throw new RuntimeException(String.format("'%s' null", nameField));
            }
        });
        return obj;
    }

}
