package org.xyou.xcommon.lock;

import java.util.HashMap;
import java.util.Map;

import lombok.NonNull;

public final class XLock {

    private static final int NUM_LOCK = 128;
    private final Map<Integer, Object> mapLock;

    public XLock() {
        mapLock = new HashMap<>();
        for (int idxLock = 0; idxLock < NUM_LOCK; idxLock++) {
            mapLock.put(idxLock, new Object());
        }
    }

    public Object get(@NonNull Object obj) {
        Integer key = obj.hashCode() % NUM_LOCK;
        return mapLock.get(key);
    }

}
