package org.xyou.xcommon.mag;

import java.util.List;
import java.util.function.Supplier;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.pool.XPool;
import org.xyou.xcommon.pool.XPoolItem;

import lombok.Getter;
import lombok.NonNull;

public final class XMag<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter
    private final Integer sizeMax;
    private final transient Supplier<V> createData;
    private final transient XPool<V> pool;

    public XMag(@NonNull Integer sizeMax, @NonNull Supplier<V> createData) {
        this.sizeMax = sizeMax;
        this.createData = createData;
        this.pool = new XPool<>(sizeMax);
        load();
    }

    private void load() {
        for (int idxObj = 0; idxObj < sizeMax; idxObj++) {
            V obj = createData.get();
            pool.offer(obj);
        }
    }

    public boolean isFull() {
        return pool.isFull();
    }

    public boolean isEmpty() {
        return pool.isEmpty();
    }

    public int size() {
        return pool.size();
    }

    public List<XPoolItem<V>> take(@NonNull Integer numItem) {
        return pool.take(numItem);
    }

    public XPoolItem<V> take() {
        return pool.take();
    }

    public synchronized List<V> reload() {
        List<V> lsData = pool.unload(sizeMax);
        load();
        return lsData;
    }

}
