package org.xyou.xcommon.pool;

import java.util.ArrayList;
import java.util.List;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.queue.XQueue;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NonNull;

public final class XPool<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter
    private final Integer sizeMax;
    @Getter(AccessLevel.PACKAGE)
    private final transient XQueue<XPoolItem<V>> queue;

    public XPool(@NonNull Integer sizeMax) {
        this.sizeMax = sizeMax;
        queue = new XQueue<>(sizeMax);
    }

    public boolean isFull() {
        return queue.isFull();
    }

    public boolean isEmpty() {
        return queue.isEmpty();
    }

    public int size() {
        return queue.size();
    }

    public List<XPoolItem<V>> take(@NonNull Integer numItem) {
        return queue.take(numItem);
    }

    public XPoolItem<V> take() {
        return queue.take();
    }

    boolean offer(@NonNull XPoolItem<V> item) {
        return queue.offer(item);
    }

    public boolean offer(@NonNull V data) {
        return offer(new XPoolItem<>(data, this));
    }

    public List<V> unload(@NonNull Integer numItem) {
        List<V> lsData = new ArrayList<>(numItem);
        for (int idxObject = 0; idxObject < numItem; idxObject++) {
            XPoolItem<V> item = queue.take();
            V data = item.getData();
            lsData.add(data);
        }
        return lsData;
    }
}
