package org.xyou.xcommon.pool;

import org.xyou.xcommon.base.XBaseObject;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

public final class XPoolItem<V> extends XBaseObject implements AutoCloseable {

    private static final long serialVersionUID = 1L;

    @Getter
    @Setter
    private V data;
    private final transient XPool<V> pool;

    XPoolItem(@NonNull V data, @NonNull XPool<V> pool) {
        this.data = data;
        this.pool = pool;
    }

    @Override
    public void close() {
        pool.offer(this);
    }
}
