package org.xyou.xcommon.profiler;

import java.util.function.Supplier;

import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.schedule.XScheduleFuture;
import org.xyou.xcommon.schedule.XScheduleParam;
import org.xyou.xcommon.time.XTime;

import io.prometheus.client.Summary;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import lombok.NonNull;

public final class XProfiler {

    private static final XLogger LOGGER = new XLogger();
    static {
        try {
            XConfig config = new XConfig("main");
            DefaultExports.initialize();
            String host = config.getStr("host");
            String[] arrPartHost = host.split(":");
            String ip = arrPartHost[0];
            Integer port = XCvt.toInt(arrPartHost[1]);
            LOGGER.info("Profiler starting at " + host);
            new HTTPServer(ip, port);
            LOGGER.info("Profiler started successfully at " + host);
        } catch (Throwable ex) {
            LOGGER.error(ex);
        }
    }

    public static XProfilerObj createObj(@NonNull Object obj) {
        return Model.getInst().createObj(obj);
    }

    public static double getCounter(@NonNull String name) {
        return Model.getInst().getCounter(name).get();
    }

    public static void incCounter(@NonNull String name) {
        incCounter(name, 1D);
    }

    public static void incCounter(@NonNull String name, @NonNull Double value) {
        Model.getInst().getCounter(name).inc(value);
    }

    public static double getGauge(@NonNull String name) {
        return Model.getInst().getGauge(name).get();
    }

    public static void setGauge(@NonNull String name, @NonNull Double value) {
        Model.getInst().getGauge(name).set(value);
    }

    public static void incGauge(@NonNull String name) {
        incGauge(name, 1D);
    }

    public static void incGauge(@NonNull String name, @NonNull Double value) {
        Model.getInst().getGauge(name).inc();
    }

    public static void decGauge(@NonNull String name) {
        decGauge(name, 1D);
    }

    public static void decGauge(@NonNull String name, @NonNull Double value) {
        Model.getInst().getGauge(name).dec();
    }

    public static XProfilerTimer getTimer(@NonNull String name) {
        Summary metric = Model.getInst().getSummary(name);
        Summary.Timer timer = metric.startTimer();
        return new XProfilerTimer(timer);
    }

    public static XScheduleFuture scheduleGauge(@NonNull String name, @NonNull Supplier<Number> func) {
        return Model.getInst().getScheduleGauge()
            .scheduleAtFixedRate(
                XScheduleParam.builder()
                    .func(() -> {
                        double value = func.get().doubleValue();
                        setGauge(name, value);
                    })
                    .msPeriod(XTime.MS_SEC)
                    .build()
            );
    }

}
