package org.xyou.xcommon.profiler;

import java.util.function.Supplier;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.schedule.XScheduleFuture;

import lombok.Getter;
import lombok.NonNull;

public final class XProfilerObj extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter
    private final String name;

    XProfilerObj(String name) {
        this.name = name;
    }

    String buildName(@NonNull String name) {
        return this.name + ":" + name;
    }

    public double getCounter(@NonNull String name) {
        return XProfiler.getCounter(buildName(name));
    }

    public void incCounter(@NonNull String name) {
        XProfiler.incCounter(buildName(name));
    }

    public void incCounter(@NonNull String name, @NonNull Double value) {
        XProfiler.incCounter(buildName(name), value);
    }

    public double getGauge(@NonNull String name) {
        return XProfiler.getGauge(buildName(name));
    }

    public void setGauge(@NonNull String name, @NonNull Double value) {
        XProfiler.setGauge(buildName(name), value);
    }

    public void incGauge(@NonNull String name) {
        XProfiler.incGauge(buildName(name));
    }

    public void incGauge(@NonNull String name, @NonNull Double value) {
        XProfiler.incGauge(buildName(name), value);
    }

    public void decGauge(@NonNull String name) {
        XProfiler.decGauge(buildName(name));
    }

    public void decGauge(@NonNull String name, @NonNull Double value) {
        XProfiler.decGauge(buildName(name), value);
    }

    public XProfilerTimer getTimer(@NonNull String name) {
        return XProfiler.getTimer(buildName(name));
    }

    public XScheduleFuture scheduleGauge(@NonNull String name, @NonNull Supplier<Number> func) {
        return XProfiler.scheduleGauge(buildName(name), func);
    }

}
