package org.xyou.xcommon.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.ex.XEx;

import lombok.NonNull;

public final class XReflect {

    public static boolean set(@NonNull Object obj, @NonNull Object key, Object value) {
        try {
            if (key instanceof String) {
                Field field = obj.getClass().getDeclaredField((String) key);
                return set(obj, field, value);
            }
            if (key instanceof Field) {
                Field field = (Field) key;
                field.setAccessible(true);
                field.set(obj, value);
                return true;
            }
            XEx.createClassInvalid(key);
        } catch (Throwable ex) {
        }
        return false;
    }

    public static <V> V get(@NonNull Object obj, @NonNull Object key) {
        try {
            if (key instanceof String) {
                return get(obj, obj.getClass().getDeclaredField((String) key));
            }
            if (key instanceof Field) {
                Field field = (Field) key;
                field.setAccessible(true);
                @SuppressWarnings("unchecked")
                V value = (V) field.get(obj);
                return value;
            }
            XEx.createClassInvalid(key);
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<Field> getLsField(@NonNull Object obj) {
        Class<?> cls = XCls.getClass(obj);
        List<Field> lsField = new ArrayList<>();
        Field[] arrField = cls.getDeclaredFields();
        for (Field field : arrField) {
            int typeModifier = field.getModifiers();
            if (field.isSynthetic()) {
                continue;
            }
            if (Modifier.isStatic(typeModifier)) {
                continue;
            }
            lsField.add(field);
        }
        return lsField;
    }

    public static List<String> getLsKey(@NonNull Object obj) {
        List<String> ls = new ArrayList<>();
        getLsField(obj).forEach(field -> {
            String ele = field.getName();
            ls.add(ele);
        });
        return ls;
    }

    public static List<Object> getLsValue(@NonNull Object obj) {
        List<Object> ls = new ArrayList<>();
        getLsField(obj).forEach(field -> {
            try {
                Object ele = get(obj, field);
                ls.add(ele);
            } catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        });
        return ls;
    }

}
