package org.xyou.xcommon.schedule;

import java.util.concurrent.ScheduledFuture;

import lombok.NonNull;

public class XScheduleFuture {

    private ScheduledFuture<?> future;

    XScheduleFuture(@NonNull ScheduledFuture<?> future) {
        this.future = future;
    }

    public Object get() {
        try {
            return future.get();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isDone() {
        return future.isDone();
    }

    public boolean isCancelled() {
        return future.isCancelled();
    }

    public boolean cancel(@NonNull Boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

}
