package org.xyou.xcommon.ser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

import lombok.NonNull;

public class XSer {

    public static byte[] serialize(@NonNull Integer in) {
        return serialize(new int[] { in });
    }

    public static byte[] serialize(@NonNull Long in) {
        return serialize(new long[] { in });
    }

    public static byte[] serialize(@NonNull Float in) {
        return serialize(new float[] { in });
    }

    public static byte[] serialize(@NonNull Double in) {
        return serialize(new double[] { in });
    }

    public static byte[] serialize(@NonNull int[] arr) {
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * Integer.BYTES).order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer buffer = bufferByte.asIntBuffer();
        for (int ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull long[] arr) {
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * Long.BYTES).order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer buffer = bufferByte.asLongBuffer();
        for (long ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull float[] arr) {
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * Float.BYTES).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer buffer = bufferByte.asFloatBuffer();
        for (float ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull double[] arr) {
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * Double.BYTES).order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer buffer = bufferByte.asDoubleBuffer();
        for (double ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static int toInt(@NonNull byte[] arrByte) {
        return toArrInt(arrByte)[0];
    }

    public static long toLong(@NonNull byte[] arrByte) {
        return toArrLong(arrByte)[0];
    }

    public static float toFloat(@NonNull byte[] arrByte) {
        return toArrFloat(arrByte)[0];
    }

    public static double toDouble(@NonNull byte[] arrByte) {
        return toArrDouble(arrByte)[0];
    }

    public static int[] toArrInt(@NonNull byte[] arrByte) {
        IntBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] ret = new int[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static long[] toArrLong(@NonNull byte[] arrByte) {
        LongBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long[] ret = new long[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static float[] toArrFloat(@NonNull byte[] arrByte) {
        FloatBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] ret = new float[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static double[] toArrDouble(@NonNull byte[] arrByte) {
        DoubleBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] ret = new double[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

}
