package org.xyou.xcommon.str;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Collection;
import java.util.List;

import org.xyou.xcommon.seq.XSeq;

import lombok.NonNull;

public final class XStr {

    public static boolean isEmpty(String data) {
        if (data == null || data.isEmpty()) {
            return true;
        }
        return false;
    }

    public static String castEmptyOnNull(String data) {
        return data == null ? "" : data;
    }

    public static String encodeBase64(@NonNull byte[] data) {
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(@NonNull String dataEncoded) {
        return Base64.getUrlDecoder().decode(dataEncoded);
    }

    public static String toSnakeFromCamel(@NonNull String data) {
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < data.length(); idx++) {
            char character = data.charAt(idx);
            if (Character.isUpperCase(character)) {
                builder.append('_');
                builder.append(Character.toLowerCase(character));
            } else {
                builder.append(character);
            }
        }
        return builder.toString();
    }

    public static String toSnakeFromSnakeUpper(@NonNull String inpt) {
        return inpt.toLowerCase();
    }

    public static String toSnakeUpperFromSnake(@NonNull String inpt) {
        return inpt.toUpperCase();
    }

    public static String toSnakeUpperFromCamel(@NonNull String inpt) {
        return toSnakeUpperFromSnake(toSnakeFromCamel(inpt));
    }

    public static String toSnakeUpperFromKebab(@NonNull String inpt) {
        return toSnakeUpperFromSnake(toSnakeFromKebab(inpt));
    }

    public static String toSnakeUpperFromPascal(@NonNull String inpt) {
        return toSnakeUpperFromSnake(toSnakeFromPascal(inpt));
    }

    public static String toSnakeFromKebab(@NonNull String inpt) {
        return inpt.replace('-', '_');
    }

    public static String toSnakeFromPascal(@NonNull String inpt) {
        return toSnakeFromCamel(toCamelFromPascal(inpt));
    }

    public static String toCamelFromPascal(@NonNull String inpt) {
        return inpt.substring(0, 1).toLowerCase() + inpt.substring(1);
    }

    public static String toCamelFromSnake(@NonNull String inpt) {
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < inpt.length(); idx++) {
            char character = inpt.charAt(idx);
            if (idx > 0 && character == '_') {
                builder.append(Character.toUpperCase(inpt.charAt(idx + 1)));
                idx += 1;
            } else {
                builder.append(character);
            }
        }
        return builder.toString();
    }

    public static String toCamelFromSnakeUpper(@NonNull String inpt) {
        return toCamelFromSnake(toSnakeFromSnakeUpper(inpt));
    }

    public static String toCamelFromKebab(@NonNull String inpt) {
        return toCamelFromSnake(toSnakeFromKebab(inpt));
    }

    public static String toPascalFromCamel(@NonNull String inpt) {
        return inpt.substring(0, 1).toUpperCase() + inpt.substring(1);
    }

    public static String toPascalFromSnake(@NonNull String inpt) {
        return toPascalFromCamel(toCamelFromSnake(inpt));
    }

    public static String toPascalFromSnakeUpper(@NonNull String inpt) {
        return toPascalFromCamel(toCamelFromSnakeUpper(inpt));
    }

    public static String toPascalFromKebab(@NonNull String inpt) {
        return toPascalFromCamel(toCamelFromKebab(inpt));
    }

    public static String toKebabFromSnake(@NonNull String inpt) {
        return inpt.replace('_', '-');
    }

    public static String toKebabFromSnakeUpper(@NonNull String inpt) {
        return toKebabFromSnake(toSnakeFromSnakeUpper(inpt));
    }

    public static String toKebabFromCamel(@NonNull String inpt) {
        return toKebabFromSnake(toSnakeFromCamel(inpt));
    }

    public static String toKebabFromPascal(@NonNull String inpt) {
        return toKebabFromSnake(toSnakeFromPascal(inpt));
    }

    public static String sliceEdge(@NonNull String inpt) {
        return inpt.substring(1, inpt.length() - 1);
    }

    public static List<String> toSnakeFromCamel(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromCamel);
    }

    public static List<String> toSnakeFromSnakeUpper(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromSnakeUpper);
    }

    public static List<String> toSnakeUpperFromSnake(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromSnake);
    }

    public static List<String> toSnakeUpperFromCamel(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromCamel);
    }

    public static List<String> toSnakeUpperFromKebab(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromKebab);
    }

    public static List<String> toSnakeUpperFromPascal(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromPascal);
    }

    public static List<String> toSnakeFromKebab(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromKebab);
    }

    public static List<String> toSnakeFromPascal(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromPascal);
    }

    public static List<String> toCamelFromPascal(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromPascal);
    }

    public static List<String> toCamelFromKebab(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromKebab);
    }

    public static List<String> toCamelFromSnake(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromSnake);
    }

    public static List<String> toCamelFromSnakeUpper(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromSnakeUpper);
    }

    public static List<String> toPascalFromCamel(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toPascalFromCamel);
    }

    public static List<String> toPascalFromKebab(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toPascalFromKebab);
    }

    public static List<String> toPascalFromSnake(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toPascalFromSnake);
    }

    public static List<String> toPascalFromSnakeUpper(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toPascalFromSnakeUpper);
    }

    public static List<String> toKebabFromSnake(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toKebabFromSnake);
    }

    public static List<String> toKebabFromCamel(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toKebabFromCamel);
    }

    public static List<String> toKebabFromSnakeUpper(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toKebabFromSnakeUpper);
    }

    public static List<String> toKebabFromPascal(@NonNull Collection<String> coll) {
        return XSeq.map(coll, XStr::toKebabFromPascal);
    }

    public static String buildStr(@NonNull InputStream stream) {
        try {
            StringBuilder builder = new StringBuilder();
            try (Reader reader = new BufferedReader(new InputStreamReader(stream))) {
                int c;
                while ((c = reader.read()) != -1) {
                    builder.append((char) c);
                }
            }
            if (builder.length() == 0) {
                return null;
            }
            return builder.toString();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
