package org.xyou.xcommon.thread;

import java.util.concurrent.Future;

import lombok.NonNull;

public class XThreadFuture {

    private Future<?> future;

    XThreadFuture(@NonNull Future<?> future) {
        this.future = future;
    }

    public Object get() {
        try {
            return future.get();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isDone() {
        return future.isDone();
    }

    public boolean isCancelled() {
        return future.isCancelled();
    }

    public boolean cancel(@NonNull Boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

}
