package org.xyou.xcommon.txt;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;

import lombok.NonNull;

public final class XTxtReader {

    public static String readAll(@NonNull String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path)));
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<String> readLineAll(@NonNull String path) {
        List<String> lsLine = new ArrayList<>();
        readLine(path, line -> lsLine.add(line));
        return lsLine;
    }

    public static boolean readLine(@NonNull String path, @NonNull Consumer<String> func) {
        try {
            File file = new File(path);
            try (Scanner scanner = new Scanner(file)) {
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    func.accept(line);
                }
            }
            return true;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
