package org.xyou.xcommon.txt;

import java.io.FileWriter;
import java.util.List;
import java.util.StringJoiner;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.file.XFile;

import lombok.Getter;
import lombok.NonNull;

public final class XTxtWriter extends XBaseObject implements AutoCloseable {

    private static final long serialVersionUID = 1L;

    @Getter
    private String path;
    private transient FileWriter writer;

    public XTxtWriter(@NonNull String path) {
        init(path, false);
    }

    public XTxtWriter(@NonNull String path, boolean append) {
        init(path, append);
    }

    private void init(@NonNull String path, boolean append) {
        try {
            this.path = path;
            String pathDirParent = XFile.dirname(path);
            XFile.mkdir(pathDirParent);
            writer = new FileWriter(path, append);
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeAll(@NonNull String path, @NonNull Object obj) {
        try (XTxtWriter writer = new XTxtWriter(path, false)) {
            writer.write(obj.toString());
        }
    }

    public static void appendAll(@NonNull String path, @NonNull Object obj) {
        try (XTxtWriter writer = new XTxtWriter(path, true)) {
            writer.write(obj.toString());
        }

    }

    public boolean writeLine(@NonNull List<Object> lsObj) {
        StringJoiner joiner = new StringJoiner("\t");
        lsObj.stream().forEach(ele -> {
            joiner.add(ele.toString());
        });
        return writeLine(joiner);
    }

    public boolean writeLine(@NonNull Object obj) {
        return write(obj, "\n");
    }

    public boolean write(@NonNull Object obj) {
        return write(obj, "");
    }

    public boolean write(@NonNull Object obj, @NonNull String suffix) {
        try {
            writer.write(obj.toString() + suffix);
            return true;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            writer.close();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
