package org.xyou.xcommon.url;

import java.net.URL;

import lombok.NonNull;

public class XUrl {

    public static URL init(@NonNull String url) {
        try {
            return new URL(url);
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getPath(@NonNull String url) {
        return init(url).getPath();
    }

    public static String getHost(@NonNull String url) {
        return init(url).getHost();
    }

    public static Integer getPort(@NonNull String url) {
        Integer port = init(url).getPort();
        if (port == -1) {
            String protocol = getProtocol(url);
            if (protocol.equals("http")) {
                return 80;
            }
            if (protocol.equals("https")) {
                return 443;
            }
        }
        if (port > 65535) {
            throw new RuntimeException("Invalid port " + port);
        }
        return port;
    }

    public static String getProtocol(@NonNull String url) {
        return init(url).getProtocol();
    }

    public static String getQuery(@NonNull String url) {
        return init(url).getQuery();
    }

}
