package org.xyou.xcommon.yaml;

import java.util.Map;

import com.fasterxml.jackson.databind.json.JsonMapper;

import lombok.NonNull;

public final class XJson {

    public static final Model model = new Model(new JsonMapper());

    public static String toStr(@NonNull Object obj) {
        return model.toStr(obj);
    }

    public static <V> V fromStr(@NonNull String content, @NonNull Class<V> cls) {
        return model.fromStr(content, cls);
    }

    public static <V> Map<String, V> fromStrToMap(@NonNull String content, @NonNull Class<V> cls) {
        return model.fromStrToMap(content, cls);
    }

    public static boolean toFile(@NonNull String path, @NonNull Object obj) {
        return model.toFile(path, obj);
    }

    public static <V> V fromFile(@NonNull Object file, @NonNull Class<V> cls) {
        return model.fromFile(file, cls);
    }

    public static <V> Map<String, V> fromFileToMap(@NonNull Object file, @NonNull Class<V> cls) {
        return model.fromFileToMap(file, cls);
    }

}
