/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.app;

import lombok.NonNull;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.function.XConsumer;
import org.xyou.xcommon.function.XRunnable;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.yaml.XYaml;

public final class XApp {
    static final transient XLogger logger = new XLogger();
    static String name = System.getProperty("zappname", "");
    static String host;
    static String branch;
    static String prof;

    public static void repeat(@NonNull Integer numTime, XRunnable func) {
        if (numTime == null) {
            throw new NullPointerException("numTime is marked non-null but is null");
        }
        XApp.repeat(numTime, (Object)func);
    }

    public static void repeat(@NonNull Integer numTime, XConsumer<Integer> func) {
        if (numTime == null) {
            throw new NullPointerException("numTime is marked non-null but is null");
        }
        XApp.repeat(numTime, func);
    }

    static void repeat(@NonNull Integer numTime, Object func) {
        if (numTime == null) {
            throw new NullPointerException("numTime is marked non-null but is null");
        }
        int idx = 0;
        while ((long)idx < numTime.longValue()) {
            if (func instanceof XRunnable) {
                ((XRunnable)func).run();
            } else if (func instanceof XConsumer) {
                XConsumer cons = (XConsumer)XCls.cast(func);
                cons.accept(idx);
            } else {
                throw XEx.createClassInvalid(func);
            }
            ++idx;
        }
    }

    public static void exit() {
        System.out.flush();
        System.exit(0);
    }

    public static String getName() {
        return name;
    }

    public static String getHost() {
        return host;
    }

    public static String getBranch() {
        return branch;
    }

    public static String getProf() {
        return prof;
    }

    static {
        prof = System.getProperty("zappprof", "");
        String pathXCiInfo = ".xci/info.yaml";
        XObj info = new XObj();
        try {
            info.putAll(XYaml.fromFile(pathXCiInfo, XObj.class));
        }
        catch (Throwable e) {
            logger.error("Read fail " + pathXCiInfo);
            logger.error(e);
        }
        name = info.getStr("name", name);
        host = info.getStr("host", "");
        branch = info.getStr("branch", "");
    }
}

