/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.codec;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.xyou.xcommon.codec.Model;
import org.xyou.xcommon.ser.XSer;
import org.xyou.xcommon.str.XStr;

public final class XCodec {
    static final transient String prefix = "x-";

    static boolean isValidId(Object id) {
        if (id instanceof String) {
            return true;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() > 0L;
        }
        return false;
    }

    public static List<String> encodeIdInt(List<Integer> lsId, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        try {
            return lsId.stream().map(id -> XCodec.encodeIdInt(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<String> encodeIdLong(List<Long> lsId, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        try {
            return lsId.stream().map(id -> XCodec.encodeIdLong(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<Integer> decodeIdInt(List<String> lsId, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        try {
            return lsId.stream().map(id -> XCodec.decodeIdInt(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<Long> decodeIdLong(List<String> lsId, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        try {
            return lsId.stream().map(id -> XCodec.decodeIdLong(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String encodeIdLong(Long id, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        if (!XCodec.isValidId(id)) {
            return null;
        }
        byte[] arrByte = XSer.serialize(id ^ (long)salt.intValue());
        return XCodec.encodeIdByte(arrByte);
    }

    public static String encodeIdInt(Integer id, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        if (!XCodec.isValidId(id)) {
            return null;
        }
        byte[] arrByte = XSer.serialize(id ^ salt);
        return XCodec.encodeIdByte(arrByte);
    }

    public static String encodeIdByte(byte[] id) {
        String encoded = XStr.encodeBase64(id);
        encoded = Model.getInst().encode(encoded);
        String encodedNoPad = encoded.substring(0, encoded.length() - 2);
        return prefix + encodedNoPad;
    }

    public static Long decodeIdLong(String idEncoded, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(prefix.length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return XSer.toLong(arrByte) ^ (long)salt.intValue();
    }

    public static Integer decodeIdInt(String idEncoded, @NonNull Integer salt) {
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(prefix.length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return XSer.toInt(arrByte) ^ salt;
    }
}

