/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.config;

import java.net.JarURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import lombok.NonNull;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.url.XUrl;
import org.xyou.xcommon.yaml.XYaml;

public final class XConfig
extends XBaseObject {
    static final XLogger logger = new XLogger();
    static final XObj mapSection = new XObj();
    final Class<?> cls;
    final String name;
    final String keyConf;
    final transient XObj section;
    final transient String prefixMsg;

    static void addConfig(@NonNull Object url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            logger.info("Read " + url);
            XYaml.fromFile(url, XObj.class).getMap().entrySet().forEach(entrySection -> XConfig.put(entrySection.getKey(), entrySection.getValue()));
        }
        catch (Throwable e) {
            logger.error("Read fail " + url);
            logger.error(e);
        }
    }

    static void put(@NonNull Object key, @NonNull Object section) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (mapSection.containsKey(key)) {
            logger.info("Overwrite section " + key);
        } else {
            logger.info("Read section " + key);
        }
        mapSection.put(key, section);
    }

    public XConfig(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.cls = XCls.getClassByTrace(1);
        String nameClass = this.cls.getSimpleName();
        this.keyConf = nameClass + "@" + name;
        Object data = mapSection.get(this.keyConf);
        this.prefixMsg = String.format("Config '%s'", this.keyConf);
        if (data == null) {
            throw new RuntimeException(this.prefixMsg + " missing");
        }
        this.section = new XObj().putAll(data);
    }

    public <V> V check(@NonNull String key, V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String prefixMsgKey = String.format(this.prefixMsg + " key '%s'", key);
        if (!this.section.containsKey(key)) {
            throw new RuntimeException(prefixMsgKey + " missing");
        }
        if (value == null) {
            throw new RuntimeException(prefixMsgKey + " value invalid");
        }
        return value;
    }

    public String getStr(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getStr(key, null));
    }

    public String getStr(@NonNull String key, String def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.section.getStr(key, def);
    }

    public Integer getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getInt(key, null));
    }

    public Integer getInt(@NonNull String key, Integer def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toInt(this.getStr(key, null), def);
    }

    public Long getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLong(key, null));
    }

    public Long getLong(@NonNull String key, Long def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toLong(this.getStr(key, null), def);
    }

    public Float getFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getFloat(key, null));
    }

    public Float getFloat(@NonNull String key, Float def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toFloat(this.getStr(key, null), def);
    }

    public Double getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getDouble(key, null));
    }

    public Double getDouble(@NonNull String key, Double def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toDouble(this.getStr(key, null), def);
    }

    public Boolean getBool(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getBool(key, null));
    }

    public Boolean getBool(@NonNull String key, Boolean def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toBool(this.getStr(key, null), def);
    }

    public List<String> getLsStr(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsStr(key, null));
    }

    public List<String> getLsStr(@NonNull String key, List<String> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return XCvt.toLsStr(this.getStr(key, null), def);
    }

    public List<Integer> getLsInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsInt(key, null));
    }

    public List<Integer> getLsInt(@NonNull String key, List<Integer> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableList(XCvt.toLsInt(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Long> getLsLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsLong(key, null));
    }

    public List<Long> getLsLong(@NonNull String key, List<Long> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableList(XCvt.toLsLong(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Float> getLsFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsFloat(key, null));
    }

    public List<Float> getLsFloat(@NonNull String key, List<Float> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableList(XCvt.toLsFloat(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Double> getLsDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsDouble(key, null));
    }

    public List<Double> getLsDouble(@NonNull String key, List<Double> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableList(XCvt.toLsDouble(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Boolean> getLsBool(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getLsBool(key, null));
    }

    public List<Boolean> getLsBool(@NonNull String key, List<Boolean> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableList(XCvt.toLsBool(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<String> getSetStr(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetStr(key, null));
    }

    public Set<String> getSetStr(@NonNull String key, Set<String> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetStr(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Integer> getSetInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetInt(key, null));
    }

    public Set<Integer> getSetInt(@NonNull String key, Set<Integer> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetInt(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Long> getSetLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetLong(key, null));
    }

    public Set<Long> getSetLong(@NonNull String key, Set<Long> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetLong(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Float> getSetFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetFloat(key, null));
    }

    public Set<Float> getSetFloat(@NonNull String key, Set<Float> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetFloat(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Double> getSetDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetDouble(key, null));
    }

    public Set<Double> getSetDouble(@NonNull String key, Set<Double> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetDouble(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Boolean> getSetBool(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.check(key, this.getSetBool(key, null));
    }

    public Set<Boolean> getSetBool(@NonNull String key, Set<Boolean> def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return Collections.unmodifiableSet(XCvt.toSetBool(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyConf() {
        return this.keyConf;
    }

    static {
        try {
            Collections.list(ClassLoader.getSystemResources("conf/production.config.ini")).forEach(url -> {
                try {
                    logger.info("Read ini " + url.getPath());
                    new Wini(url).entrySet().forEach(entrySection -> {
                        XObj section = new XObj();
                        ((Profile.Section)entrySection.getValue()).entrySet().forEach(entry -> section.put(entry.getKey(), entry.getValue()));
                        XConfig.put(entrySection.getKey(), section);
                    });
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            String nameDir = "xconfig";
            Collections.list(ClassLoader.getSystemResources(nameDir)).forEach(urlDir -> {
                block15: {
                    try {
                        String pathDir = urlDir.getPath();
                        logger.info("At " + pathDir);
                        if (XFile.exist(pathDir)) {
                            XFile.ls(pathDir).forEach(name -> XConfig.addConfig(pathDir + "/" + name));
                            break block15;
                        }
                        try (JarFile file = ((JarURLConnection)urlDir.openConnection()).getJarFile();){
                            Collections.list(file.entries()).forEach(ele -> {
                                String name = ele.getName();
                                if (!XFile.basename(XFile.dirname(name)).equals(nameDir)) {
                                    return;
                                }
                                XConfig.addConfig(XUrl.init(urlDir + "/" + XFile.basename(name)));
                            });
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }
}

