/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.ex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import lombok.NonNull;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.ex.XClassInvalidException;
import org.xyou.xcommon.ex.XFieldNullException;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.str.XStrJoiner;

public final class XEx {
    public static XClassInvalidException createClassInvalid(Object ... arrObj) throws RuntimeException {
        if (arrObj == null) {
            throw new NullPointerException("arrObj is marked non-null but is null");
        }
        XStrJoiner joiner = new XStrJoiner(", ");
        XSeq.forEach(arrObj, e -> joiner.add(e.getClass().getName()));
        return new XClassInvalidException("Class invalid " + joiner);
    }

    public static Object checkClassValid(@NonNull Object obj, Class<?> ... arrCls) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (arrCls == null) {
            throw new NullPointerException("arrCls is marked non-null but is null");
        }
        for (Class<?> cls : arrCls) {
            if (!XCls.is(obj, cls).booleanValue()) continue;
            return obj;
        }
        throw XEx.createClassInvalid(obj);
    }

    private static XFieldNullException createFieldNull(@NonNull String name) throws RuntimeException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new XFieldNullException(String.format("'%s' null", name));
    }

    public static Object checkFieldNotNull(@NonNull Object obj, String ... arrNameField) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (arrNameField == null) {
            throw new NullPointerException("arrNameField is marked non-null but is null");
        }
        if (obj instanceof XObj) {
            XObj objX = (XObj)obj;
            XSeq.forEach(arrNameField, e -> {
                if (objX.get(e) == null) {
                    throw XEx.createFieldNull(e);
                }
            });
        }
        Set<String> setNameField = XSeq.newHashSet(arrNameField);
        XCls.getLsField(obj.getClass()).forEach(field -> {
            String nameField = field.getName();
            if (!setNameField.contains(nameField)) {
                return;
            }
            if (XCls.get(obj, field) == null) {
                throw XEx.createFieldNull(nameField);
            }
        });
        return obj;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

