/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.tika.Tika;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.txt.XTxtReader;

public final class XFile {
    static final transient Tika tika = new Tika();

    public static void touch(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            XFile.mkdir(XFile.dirname(path));
            new File(path).createNewFile();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isfile(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new File(path).isFile();
    }

    public static boolean isdir(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new File(path).isDirectory();
    }

    public static boolean exist(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new File(path).exists();
    }

    public static void rm(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        File[] arrFile = file.listFiles();
        if (!XSeq.isEmpty(arrFile)) {
            XSeq.forEach(arrFile, fileInner -> {
                try {
                    XFile.rm(fileInner.getPath());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        file.delete();
    }

    public static String normpath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Paths.get("/", path).normalize().toString();
    }

    public static String realpath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        return file.getAbsoluteFile().getPath();
    }

    public static String dirname(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        return file.getAbsoluteFile().getParent();
    }

    public static String basename(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        return file.getName();
    }

    public static void mkdir(@NonNull String pathDir) {
        if (pathDir == null) {
            throw new NullPointerException("pathDir is marked non-null but is null");
        }
        if (XFile.exist(pathDir)) {
            return;
        }
        if (!new File(pathDir).mkdirs()) {
            throw new RuntimeException("Create directory fail " + pathDir);
        }
    }

    public static boolean empty(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (XFile.isfile(path)) {
            return XTxtReader.readAll(path).equals("");
        }
        if (XFile.isdir(path)) {
            return XFile.ls(path).size() == 0;
        }
        throw new RuntimeException("Not exist " + path);
    }

    public static List<String> ls(@NonNull String dir) {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (!XFile.isdir(dir)) {
            throw new RuntimeException("No directory " + dir);
        }
        return XSeq.newArrayList(new File(dir).listFiles()).stream().map(File::getName).collect(Collectors.toList());
    }

    public static List<String> walk(@NonNull String dir) {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        ArrayList<String> lsPathAll = new ArrayList<String>();
        XFile.ls(dir).forEach(name -> {
            lsPathAll.add((String)name);
            String path = dir + "/" + name;
            if (!XFile.isdir(path)) {
                return;
            }
            XFile.walk(path).forEach(nameInner -> {
                String pathInner = name + "/" + nameInner;
                lsPathAll.add(pathInner);
            });
        });
        return lsPathAll;
    }

    public static String mime(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try {
            if (obj instanceof String) {
                return tika.detect((String)obj);
            }
            if (obj instanceof File) {
                return tika.detect((File)obj);
            }
            if (obj instanceof InputStream) {
                return tika.detect((InputStream)obj);
            }
            if (obj instanceof Path) {
                return tika.detect((Path)obj);
            }
            if (obj instanceof URL) {
                return tika.detect((URL)obj);
            }
            if (obj instanceof byte[]) {
                return tika.detect((byte[])obj);
            }
            throw XEx.createClassInvalid(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void cp(@NonNull Object from, @NonNull Object to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        try {
            if (to instanceof OutputStream) {
                OutputStream streamTo = (OutputStream)to;
                Files.copy(Paths.get((String)from, new String[0]), streamTo);
                streamTo.flush();
                return;
            }
            if (to instanceof String) {
                if (from instanceof InputStream) {
                    String pathTo = (String)to;
                    Files.copy((InputStream)from, Paths.get(pathTo, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    return;
                }
                String pathFrom = (String)from;
                String pathTo = (String)to;
                XFile.mkdir(XFile.dirname(pathTo));
                if (XFile.isdir(pathFrom)) {
                    XFile.ls(pathFrom).forEach(name -> XFile.cp(pathFrom + "/" + name, pathTo + "/" + name));
                    return;
                }
                Files.copy(Paths.get(pathFrom, new String[0]), Paths.get(pathTo, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            throw XEx.createClassInvalid(to);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void mv(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        try {
            XFile.rm(to);
            XFile.mkdir(XFile.dirname(to));
            Files.move(Paths.get(from, new String[0]), Paths.get(to, new String[0]), new CopyOption[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

