/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.logger;

import java.io.Serializable;
import lombok.NonNull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.xyou.xcommon.cls.XCls;

public final class XLogger
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final String FQCN = XLogger.class.getName();
    static final Level ERROR = Level.forName((String)"ERROR", (int)200);
    static final Level INFO = Level.forName((String)"INFO", (int)400);
    transient ExtendedLoggerWrapper logger;
    Class<?> cls;

    public XLogger() {
        this.init(XCls.getClassByTrace(1));
    }

    public void init(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        this.cls = cls;
        Logger loggerWrapped = LogManager.getLogger(cls);
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)((AbstractLogger)loggerWrapped), loggerWrapped.getName(), loggerWrapped.getMessageFactory());
    }

    public void error(@NonNull Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        this.logger.logIfEnabled(FQCN, ERROR, null, cause.getMessage(), cause);
    }

    public void error(Object message) {
        this.logger.logIfEnabled(FQCN, ERROR, null, message, (Throwable)null);
    }

    public void info(Object message) {
        this.logger.logIfEnabled(FQCN, INFO, null, message, (Throwable)null);
    }

    public Class<?> getCls() {
        return this.cls;
    }
}

