/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.mag;

import java.util.List;
import lombok.NonNull;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.function.XSupplier;
import org.xyou.xcommon.pool.XPool;
import org.xyou.xcommon.pool.XPoolItem;

public final class XMag<V>
extends XBaseObject {
    final Integer sizeMax;
    final transient XSupplier<V> createData;
    final transient XPool<V> pool;

    public XMag(@NonNull Integer sizeMax, @NonNull XSupplier<V> createData) {
        if (sizeMax == null) {
            throw new NullPointerException("sizeMax is marked non-null but is null");
        }
        if (createData == null) {
            throw new NullPointerException("createData is marked non-null but is null");
        }
        this.sizeMax = sizeMax;
        this.createData = createData;
        this.pool = new XPool(sizeMax);
        this.load();
    }

    void load() {
        XApp.repeat(this.sizeMax, () -> this.pool.offer(this.createData.get()));
    }

    public boolean isFull() {
        return this.pool.isFull();
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public int size() {
        return this.pool.size();
    }

    public List<XPoolItem<V>> take(@NonNull Integer numItem) {
        if (numItem == null) {
            throw new NullPointerException("numItem is marked non-null but is null");
        }
        return this.pool.take(numItem);
    }

    public XPoolItem<V> take() {
        return this.pool.take();
    }

    public synchronized List<V> reload() {
        List<V> lsData = this.pool.unload(this.sizeMax);
        this.load();
        return lsData;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }
}

