/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.xyou.xcommon.function.XConsumer2;
import org.xyou.xcommon.function.XConsumer3;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.function.XFunction2;
import org.xyou.xcommon.seq.XSeq;

public final class XMap {
    public static <K, V> Map<K, V> of(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        Map<K, V> map = XMap.of(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        Map<K, V> map = XMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        map.put(k10, v10);
        return map;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> Map<V, K> reverse(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        HashMap mapData = new HashMap();
        map.entrySet().forEach(entry -> mapData.put(entry.getValue(), entry.getKey()));
        return mapData;
    }

    public static <K, V> List<K> getLsKeySortedByValue(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        ArrayList<Map.Entry<K, V>> lsEntry = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(lsEntry, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
            }
        });
        List lsKey = lsEntry.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        return lsKey;
    }

    public static <K, V> List<V> getLsValueByLsKey(@NonNull Map<K, V> map, @NonNull Collection<K> collKey) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (collKey == null) {
            throw new NullPointerException("collKey is marked non-null but is null");
        }
        ArrayList lsData = new ArrayList();
        collKey.forEach(key -> {
            Object value = map.get(key);
            if (value == null) {
                return;
            }
            lsData.add(value);
        });
        return lsData;
    }

    static <K, V> Set<K> mergeKey(List<Map<K, V>> lsMap) {
        HashSet setKey = new HashSet();
        lsMap.forEach(map -> setKey.addAll(map.keySet()));
        return setKey;
    }

    public static <K, V, T> Map<K, T> map(@NonNull Map<K, V> map, @NonNull XFunction<V, T> func) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        HashMap mapData = new HashMap();
        map.entrySet().forEach(entry -> {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object data = func.apply(value);
            mapData.put(key, data);
        });
        return mapData;
    }

    public static <K, V> Map<K, V> reduce(@NonNull List<Map<K, V>> lsMap, V def, @NonNull XFunction2<V, V, V> func) {
        if (lsMap == null) {
            throw new NullPointerException("lsMap is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        HashMap mapData = new HashMap();
        Set<K> setKey = XMap.mergeKey(lsMap);
        XSeq.forEach(setKey, (V k) -> XSeq.forEach(lsMap, (V m) -> {
            Object data = mapData.getOrDefault(k, def);
            Object value = m.getOrDefault(k, def);
            data = func.apply(data, value);
            mapData.put(k, data);
        }));
        return mapData;
    }

    public static <K, V extends Number> Map<K, Double> normLog(@NonNull Map<K, V> map) {
        double maxLog;
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        double max = ((Number)XSeq.max(map.values())).doubleValue();
        double maxLogFinal = maxLog = max > 1.0 ? Math.log(max) : 1.0;
        HashMap mapIdSongCountNorm = new HashMap();
        XMap.forEach(map, (K k, V v) -> mapIdSongCountNorm.put(k, Math.log(v.doubleValue()) / maxLogFinal));
        return mapIdSongCountNorm;
    }

    public static <K, V extends Number> Map<K, Double> normMax(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        double max = ((Number)XSeq.max(map.values())).doubleValue();
        HashMap mapIdSongCountNorm = new HashMap();
        XMap.forEach(map, (K k, V v) -> {
            double countNorm = v.doubleValue() / max;
            mapIdSongCountNorm.put(k, countNorm);
        });
        return mapIdSongCountNorm;
    }

    public static <K, V> void forEach(Map<K, V> map, @NonNull XConsumer2<K, V> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XMap.forEach(map, (K k, V v, Integer i) -> func.accept(k, v));
    }

    public static <K, V> void forEach(Map<K, V> map, @NonNull XConsumer3<K, V, Integer> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(map.entrySet(), (V e, Integer i) -> func.accept(e.getKey(), e.getValue(), (Integer)i));
    }
}

