/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.profiler;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.function.XSupplier;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.profiler.XProfilerTimer;
import org.xyou.xcommon.schedule.XSchedule;
import org.xyou.xcommon.schedule.XScheduleFuture;
import org.xyou.xcommon.schedule.XScheduleParam;
import org.xyou.xcommon.str.XStr;

public final class XProfiler {
    static final transient XLogger logger = new XLogger();
    static String nameService;
    static String ip;
    static Integer port;
    static final transient Map<String, Counter> mapCounter;
    static final transient Map<String, Gauge> mapGauge;
    static final transient Map<String, Summary> mapSummary;
    static final transient XSchedule scheduleGauge;
    static final transient Map<String, Integer> mapNumObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V getMetric(@NonNull String name, @NonNull Map<String, V> mapMetric, @NonNull XFunction<String, V> buildMetric) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (mapMetric == null) {
            throw new NullPointerException("mapMetric is marked non-null but is null");
        }
        if (buildMetric == null) {
            throw new NullPointerException("buildMetric is marked non-null but is null");
        }
        String nameMetric = nameService + ":" + name;
        if (!mapMetric.containsKey(nameMetric)) {
            Map<String, V> map = mapMetric;
            synchronized (map) {
                if (!mapMetric.containsKey(nameMetric)) {
                    V metric = buildMetric.apply(nameMetric);
                    mapMetric.put(nameMetric, metric);
                }
            }
        }
        return mapMetric.get(nameMetric);
    }

    static Counter getMetricCounter(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getMetric(name, mapCounter, k -> (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name(k)).help("x")).register());
    }

    static Gauge getMetricGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getMetric(name, mapGauge, k -> (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(k)).help("x")).register());
    }

    static Summary getMetricSummary(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getMetric(name, mapSummary, k -> (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name(k)).help("x")).register());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XProfilerObj createObj(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Map<String, Integer> map = mapNumObject;
        synchronized (map) {
            String nameCls = obj.getClass().getSimpleName();
            String name = XObj.fromObject(obj).getStr("name");
            Integer numObject = mapNumObject.getOrDefault(name, 0);
            String nameClsSnakeCase = XStr.toSnakeFromPascal(nameCls);
            String nameRegister = XStr.join((Object)":", nameClsSnakeCase, name, numObject);
            numObject = numObject + 1;
            mapNumObject.put(name, numObject);
            return new XProfilerObj(nameRegister);
        }
    }

    public static double getCounter(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getMetricCounter(name).get();
    }

    public static void incCounter(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.incCounter(name, 1.0);
    }

    public static void incCounter(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.getMetricCounter(name).inc(value.doubleValue());
    }

    public static double getGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getMetricGauge(name).get();
    }

    public static void setGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.getMetricGauge(name).set(value.doubleValue());
    }

    public static void incGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.incGauge(name, 1.0);
    }

    public static void incGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.getMetricGauge(name).inc();
    }

    public static void decGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.decGauge(name, 1.0);
    }

    public static void decGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.getMetricGauge(name).dec();
    }

    public static XProfilerTimer getTimer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Summary metric = XProfiler.getMetricSummary(name);
        Summary.Timer timer = metric.startTimer();
        return new XProfilerTimer(timer);
    }

    public static XScheduleFuture scheduleGauge(@NonNull String name, @NonNull XSupplier<Number> func) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return scheduleGauge.scheduleAtFixedRate(XScheduleParam.builder().func(() -> XProfiler.setGauge(name, ((Number)func.get()).doubleValue())).msPeriod(1000L).build());
    }

    public static String getNameService() {
        return nameService;
    }

    public static String getIp() {
        return ip;
    }

    public static Integer getPort() {
        return port;
    }

    static {
        mapCounter = new HashMap<String, Counter>();
        mapGauge = new HashMap<String, Gauge>();
        mapSummary = new HashMap<String, Summary>();
        scheduleGauge = new XSchedule();
        mapNumObject = new HashMap<String, Integer>();
        try {
            nameService = XStr.toSnakeFromKebab(XApp.getName());
            XConfig config = new XConfig(XApp.getBranch());
            DefaultExports.initialize();
            String host = config.getStr("host");
            String[] arrPartHost = host.split(":");
            ip = arrPartHost[0];
            port = XCvt.toInt(arrPartHost[1]);
            logger.info(config.getKeyConf() + " starting at " + host);
            new HTTPServer(ip, port.intValue());
            logger.info(config.getKeyConf() + " started successfully at " + host);
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }
}

