/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.profiler;

import lombok.NonNull;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.function.XSupplier;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerTimer;
import org.xyou.xcommon.schedule.XScheduleFuture;

public final class XProfilerObj
extends XBaseObject {
    final String name;

    XProfilerObj(String name) {
        this.name = name;
    }

    String buildName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name + ":" + name;
    }

    public double getCounter(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getCounter(this.buildName(name));
    }

    public void incCounter(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.incCounter(this.buildName(name));
    }

    public void incCounter(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.incCounter(this.buildName(name), value);
    }

    public double getGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getGauge(this.buildName(name));
    }

    public void setGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.setGauge(this.buildName(name), value);
    }

    public void incGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.incGauge(this.buildName(name));
    }

    public void incGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.incGauge(this.buildName(name), value);
    }

    public void decGauge(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XProfiler.decGauge(this.buildName(name));
    }

    public void decGauge(@NonNull String name, @NonNull Double value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        XProfiler.decGauge(this.buildName(name), value);
    }

    public XProfilerTimer getTimer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return XProfiler.getTimer(this.buildName(name));
    }

    public XScheduleFuture scheduleGauge(@NonNull String name, @NonNull XSupplier<Number> func) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XProfiler.scheduleGauge(this.buildName(name), func);
    }

    public String getName() {
        return this.name;
    }
}

