/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.schedule;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.schedule.XScheduleFuture;
import org.xyou.xcommon.schedule.XScheduleParam;

public final class XSchedule {
    static final String ID_ZONE_VN_HCM = "Asia/Ho_Chi_Minh";
    transient ScheduledExecutorService service;

    public XSchedule(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        XConfig config = new XConfig(name);
        Integer numThread = config.getInt("numThread");
        this.init(numThread);
    }

    public XSchedule() {
        this.init(1);
    }

    public XSchedule(@NonNull Integer numThread) {
        if (numThread == null) {
            throw new NullPointerException("numThread is marked non-null but is null");
        }
        this.init(numThread);
    }

    public void init(@NonNull Integer numThread) {
        if (numThread == null) {
            throw new NullPointerException("numThread is marked non-null but is null");
        }
        this.service = Executors.newScheduledThreadPool(numThread);
    }

    public int sizeQueue() {
        ScheduledThreadPoolExecutor poolThread = (ScheduledThreadPoolExecutor)this.service;
        return poolThread.getQueue().size();
    }

    public boolean shutdown() {
        return this.shutdown(Long.MAX_VALUE);
    }

    public boolean shutdown(@NonNull Long msWait) {
        if (msWait == null) {
            throw new NullPointerException("msWait is marked non-null but is null");
        }
        try {
            this.service.shutdown();
            return this.service.awaitTermination(msWait, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public XScheduleFuture scheduleDaily(@NonNull Integer hr, @NonNull Runnable func) {
        if (hr == null) {
            throw new NullPointerException("hr is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return this.scheduleDaily(XScheduleParam.builder().hr(hr).func(func).build());
    }

    public XScheduleFuture scheduleDaily(@NonNull XScheduleParam param) {
        ZonedDateTime nextRun;
        Integer sec;
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        XEx.checkFieldNotNull(param, "func", "hr");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(ID_ZONE_VN_HCM));
        Integer hr = param.getHr();
        Integer min = param.getMin();
        if (min == null) {
            min = 0;
        }
        if ((sec = param.getMin()) == null) {
            sec = 0;
        }
        if (now.compareTo(nextRun = now.withHour(hr).withMinute(min).withSecond(sec)) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        long initalDelay = duration.getSeconds();
        Runnable func = param.getFunc();
        return this.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(86400000L).msDelayInit(initalDelay * 1000L).func(func).build());
    }

    public XScheduleFuture scheduleHourly(@NonNull Integer min, Runnable func) {
        if (min == null) {
            throw new NullPointerException("min is marked non-null but is null");
        }
        return this.scheduleHourly(XScheduleParam.builder().min(min).func(func).build());
    }

    public XScheduleFuture scheduleHourly(@NonNull XScheduleParam param) {
        ZonedDateTime nextRun;
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        XEx.checkFieldNotNull(param, "func", "min");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(ID_ZONE_VN_HCM));
        Integer min = param.getMin();
        Integer sec = param.getMin();
        if (sec == null) {
            sec = 0;
        }
        if (now.compareTo(nextRun = now.withMinute(min).withSecond(sec)) > 0) {
            nextRun = nextRun.plusHours(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        long initalDelay = duration.getSeconds();
        Runnable func = param.getFunc();
        return this.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(3600000L).msDelayInit(initalDelay * 1000L).func(func).build());
    }

    public XScheduleFuture scheduleAtFixedRate(@NonNull Long msPeriod, @NonNull Runnable func) {
        if (msPeriod == null) {
            throw new NullPointerException("msPeriod is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return this.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(msPeriod).func(func).build());
    }

    public XScheduleFuture scheduleAtFixedRate(@NonNull XScheduleParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        XEx.checkFieldNotNull(param, "func", "msPeriod");
        Long msPeriod = param.getMsPeriod();
        Long msDelayInit = param.getMsDelayInit();
        if (msDelayInit == null) {
            msDelayInit = 0L;
        }
        Runnable func = param.getFunc();
        return new XScheduleFuture(this.service.scheduleAtFixedRate(func::run, msDelayInit, msPeriod, TimeUnit.MILLISECONDS));
    }

    public XScheduleFuture scheduleWithFixedDelay(@NonNull Long msDelay, @NonNull Runnable func) {
        if (msDelay == null) {
            throw new NullPointerException("msDelay is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return this.scheduleWithFixedDelay(XScheduleParam.builder().msDelay(msDelay).func(func).build());
    }

    public XScheduleFuture scheduleWithFixedDelay(@NonNull XScheduleParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        XEx.checkFieldNotNull(param, "func", "msDelay");
        Runnable func = param.getFunc();
        Long msDelay = param.getMsDelay();
        Long msDelayInit = param.getMsDelayInit();
        if (msDelayInit == null) {
            msDelayInit = 0L;
        }
        return new XScheduleFuture(this.service.scheduleWithFixedDelay(func::run, msDelayInit, msDelay, TimeUnit.MILLISECONDS));
    }
}

