/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.ser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import lombok.NonNull;

public class XSer {
    public static byte[] serialize(@NonNull Integer in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XSer.serialize(new int[]{in});
    }

    public static byte[] serialize(@NonNull Long in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XSer.serialize(new long[]{in});
    }

    public static byte[] serialize(@NonNull Float in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XSer.serialize(new float[]{in.floatValue()});
    }

    public static byte[] serialize(@NonNull Double in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XSer.serialize(new double[]{in});
    }

    public static byte[] serialize(@NonNull int[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer buffer = bufferByte.asIntBuffer();
        for (int ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull long[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * 8).order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer buffer = bufferByte.asLongBuffer();
        for (long ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull float[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer buffer = bufferByte.asFloatBuffer();
        for (float ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static byte[] serialize(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        ByteBuffer bufferByte = ByteBuffer.allocate(arr.length * 8).order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer buffer = bufferByte.asDoubleBuffer();
        for (double ele : arr) {
            buffer.put(ele);
        }
        return bufferByte.array();
    }

    public static int toInt(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        return XSer.toArrInt(arrByte)[0];
    }

    public static long toLong(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        return XSer.toArrLong(arrByte)[0];
    }

    public static float toFloat(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        return XSer.toArrFloat(arrByte)[0];
    }

    public static double toDouble(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        return XSer.toArrDouble(arrByte)[0];
    }

    public static int[] toArrInt(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        IntBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] ret = new int[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static long[] toArrLong(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        LongBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long[] ret = new long[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static float[] toArrFloat(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        FloatBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] ret = new float[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }

    public static double[] toArrDouble(@NonNull byte[] arrByte) {
        if (arrByte == null) {
            throw new NullPointerException("arrByte is marked non-null but is null");
        }
        DoubleBuffer buffer = ByteBuffer.wrap(arrByte).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] ret = new double[buffer.capacity()];
        buffer.get(ret);
        return ret;
    }
}

