/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.txt;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import lombok.NonNull;
import org.xyou.xcommon.function.XConsumer;

public final class XTxtReader {
    public static String readAll(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLineAll(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArrayList<String> lsLine = new ArrayList<String>();
        XTxtReader.readLine(path, lsLine::add);
        return lsLine;
    }

    public static boolean readLine(@NonNull String path, @NonNull XConsumer<String> func) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        try {
            File file = new File(path);
            try (Scanner scanner = new Scanner(file);){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    func.accept(line);
                }
            }
            return true;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

