/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.txt;

import java.io.FileWriter;
import lombok.NonNull;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.str.XStrJoiner;

public final class XTxtWriter
extends XBaseObject
implements AutoCloseable {
    String path;
    transient FileWriter writer;

    public XTxtWriter(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.init(path, false);
    }

    public XTxtWriter(@NonNull String path, boolean append) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.init(path, append);
    }

    void init(@NonNull String path, boolean append) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            this.path = path;
            String pathDirParent = XFile.dirname(path);
            XFile.mkdir(pathDirParent);
            this.writer = new FileWriter(path, append);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAll(@NonNull String path, @NonNull Object obj) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try (XTxtWriter writer = new XTxtWriter(path, false);){
            writer.write(obj.toString());
        }
    }

    public static void appendAll(@NonNull String path, @NonNull Object obj) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try (XTxtWriter writer = new XTxtWriter(path, true);){
            writer.write(obj.toString());
        }
    }

    public XTxtWriter writeLine(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return this.write(obj, "\n");
    }

    public XTxtWriter write(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return this.write(obj, "");
    }

    public XTxtWriter write(@NonNull Object obj, @NonNull String suffix) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        try {
            if (obj instanceof Iterable) {
                XStrJoiner joiner = new XStrJoiner("\t");
                ((Iterable)obj).forEach(ele -> joiner.add(ele.toString()));
                return this.writeLine(joiner);
            }
            this.writer.write(obj.toString() + suffix);
            return this;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.path;
    }
}

