/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.yaml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.file.XFile;

class Model {
    final transient ObjectMapper mapper;

    Model(ObjectMapper mapper) {
        this.mapper = mapper;
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Timestamp.class, (JsonSerializer)new StdSerializer<Timestamp>(Timestamp.class){

            public void serialize(Timestamp value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeNumber(value.getTime() / 1000L);
            }
        });
        module.addDeserializer(Timestamp.class, (JsonDeserializer)new StdDeserializer<Timestamp>(Timestamp.class){

            public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return new Timestamp(p.getValueAsLong() * 1000L);
            }
        });
        module.addSerializer(XObj.class, (JsonSerializer)new StdSerializer<XObj>(XObj.class){

            public void serialize(XObj value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                Map<Object, Object> map = value.getMap();
                gen.writeObject(map);
            }
        });
        module.addDeserializer(XObj.class, (JsonDeserializer)new StdDeserializer<XObj>(XObj.class){

            public XObj deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Map map = (Map)XCls.cast(p.readValueAs(Map.class));
                return new XObj().putAll(map);
            }
        });
        mapper.registerModule((Module)module);
    }

    String toStr(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    <V> V fromStr(String str, Class<V> cls) {
        try {
            Object obj = this.mapper.readValue(str, cls);
            return (V)obj;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    <V> Map<String, V> fromStrToMap(@NonNull String data, @NonNull Class<V> cls) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        try {
            MapType mapType = this.mapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, cls);
            return (Map)this.mapper.readValue(data, (JavaType)mapType);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    boolean toFile(@NonNull String path, @NonNull Object obj) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try {
            XFile.mkdir(XFile.dirname(path));
            this.mapper.writeValue(new File(path), obj);
            return true;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    <V> V fromFile(@NonNull Object obj, @NonNull Class<V> cls) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        try {
            if (obj instanceof String) {
                return (V)this.mapper.readValue(new File((String)obj), cls);
            }
            if (obj instanceof File) {
                return (V)this.mapper.readValue((File)obj, cls);
            }
            if (obj instanceof InputStream) {
                return (V)this.mapper.readValue((InputStream)obj, cls);
            }
            if (obj instanceof URL) {
                return (V)this.mapper.readValue((URL)obj, cls);
            }
            throw XEx.createClassInvalid(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    <V> Map<String, V> fromFileToMap(@NonNull Object obj, @NonNull Class<V> cls) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        try {
            MapType mapType = this.mapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, cls);
            if (obj instanceof String) {
                return (Map)this.mapper.readValue(new File((String)obj), (JavaType)mapType);
            }
            if (obj instanceof File) {
                return (Map)this.mapper.readValue((File)obj, (JavaType)mapType);
            }
            if (obj instanceof InputStream) {
                return (Map)this.mapper.readValue((InputStream)obj, (JavaType)mapType);
            }
            if (obj instanceof URL) {
                return (Map)this.mapper.readValue((URL)obj, (JavaType)mapType);
            }
            throw XEx.createClassInvalid(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }
}

